package zio.aws.wafregional
import zio.aws.wafregional.model.primitives.GetSampledRequestsMaxItems.Type
import java.time.Instant
import zio.Chunk
import zio.prelude.Subtype
import zio.aws.wafregional.model.primitives.{
  TagKey,
  RegexPatternString,
  ManagedKey,
  ResourceArn
}
package object model {
  import scala.jdk.CollectionConverters.*
  object primitives {
    object Action extends Subtype[String]
    type Action = zio.aws.wafregional.model.primitives.Action.Type
    object ByteMatchTargetString extends Subtype[Chunk[Byte]]
    type ByteMatchTargetString =
      zio.aws.wafregional.model.primitives.ByteMatchTargetString.Type
    object ChangeToken extends Subtype[String]
    type ChangeToken = zio.aws.wafregional.model.primitives.ChangeToken.Type
    object Country extends Subtype[String]
    type Country = zio.aws.wafregional.model.primitives.Country.Type
    object GetSampledRequestsMaxItems extends Subtype[Long]
    type GetSampledRequestsMaxItems =
      zio.aws.wafregional.model.primitives.GetSampledRequestsMaxItems.Type
    object HTTPMethod extends Subtype[String]
    type HTTPMethod = zio.aws.wafregional.model.primitives.HTTPMethod.Type
    object HTTPVersion extends Subtype[String]
    type HTTPVersion = zio.aws.wafregional.model.primitives.HTTPVersion.Type
    object HeaderName extends Subtype[String]
    type HeaderName = zio.aws.wafregional.model.primitives.HeaderName.Type
    object HeaderValue extends Subtype[String]
    type HeaderValue = zio.aws.wafregional.model.primitives.HeaderValue.Type
    object IPSetDescriptorValue extends Subtype[String]
    type IPSetDescriptorValue =
      zio.aws.wafregional.model.primitives.IPSetDescriptorValue.Type
    object IPString extends Subtype[String]
    type IPString = zio.aws.wafregional.model.primitives.IPString.Type
    object IgnoreUnsupportedType extends Subtype[Boolean]
    type IgnoreUnsupportedType =
      zio.aws.wafregional.model.primitives.IgnoreUnsupportedType.Type
    object ManagedKey extends Subtype[String]
    type ManagedKey = zio.aws.wafregional.model.primitives.ManagedKey.Type
    object MatchFieldData extends Subtype[String]
    type MatchFieldData =
      zio.aws.wafregional.model.primitives.MatchFieldData.Type
    object MetricName extends Subtype[String]
    type MetricName = zio.aws.wafregional.model.primitives.MetricName.Type
    object Negated extends Subtype[Boolean]
    type Negated = zio.aws.wafregional.model.primitives.Negated.Type
    object NextMarker extends Subtype[String]
    type NextMarker = zio.aws.wafregional.model.primitives.NextMarker.Type
    object PaginationLimit extends Subtype[Int]
    type PaginationLimit =
      zio.aws.wafregional.model.primitives.PaginationLimit.Type
    object PolicyString extends Subtype[String]
    type PolicyString = zio.aws.wafregional.model.primitives.PolicyString.Type
    object PopulationSize extends Subtype[Long]
    type PopulationSize =
      zio.aws.wafregional.model.primitives.PopulationSize.Type
    object RateLimit extends Subtype[Long]
    type RateLimit = zio.aws.wafregional.model.primitives.RateLimit.Type
    object RegexPatternString extends Subtype[String]
    type RegexPatternString =
      zio.aws.wafregional.model.primitives.RegexPatternString.Type
    object ResourceArn extends Subtype[String]
    type ResourceArn = zio.aws.wafregional.model.primitives.ResourceArn.Type
    object ResourceId extends Subtype[String]
    type ResourceId = zio.aws.wafregional.model.primitives.ResourceId.Type
    object ResourceName extends Subtype[String]
    type ResourceName = zio.aws.wafregional.model.primitives.ResourceName.Type
    object RulePriority extends Subtype[Int]
    type RulePriority = zio.aws.wafregional.model.primitives.RulePriority.Type
    object S3BucketName extends Subtype[String]
    type S3BucketName = zio.aws.wafregional.model.primitives.S3BucketName.Type
    object S3ObjectUrl extends Subtype[String]
    type S3ObjectUrl = zio.aws.wafregional.model.primitives.S3ObjectUrl.Type
    object SampleWeight extends Subtype[Long]
    type SampleWeight = zio.aws.wafregional.model.primitives.SampleWeight.Type
    object Size extends Subtype[Long]
    type Size = zio.aws.wafregional.model.primitives.Size.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.wafregional.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.wafregional.model.primitives.TagValue.Type
    object Timestamp extends Subtype[Instant]
    type Timestamp = zio.aws.wafregional.model.primitives.Timestamp.Type
    object URIString extends Subtype[String]
    type URIString = zio.aws.wafregional.model.primitives.URIString.Type
  }
  type ActivatedRules = List[zio.aws.wafregional.model.ActivatedRule]
  type ByteMatchSetSummaries =
    List[zio.aws.wafregional.model.ByteMatchSetSummary]
  type ByteMatchSetUpdates = List[zio.aws.wafregional.model.ByteMatchSetUpdate]
  type ByteMatchTuples = List[zio.aws.wafregional.model.ByteMatchTuple]
  type ExcludedRules = List[zio.aws.wafregional.model.ExcludedRule]
  type GeoMatchConstraints = List[zio.aws.wafregional.model.GeoMatchConstraint]
  type GeoMatchSetSummaries = List[zio.aws.wafregional.model.GeoMatchSetSummary]
  type GeoMatchSetUpdates = List[zio.aws.wafregional.model.GeoMatchSetUpdate]
  type HTTPHeaders = List[zio.aws.wafregional.model.HTTPHeader]
  type IPSetDescriptors = List[zio.aws.wafregional.model.IPSetDescriptor]
  type IPSetSummaries = List[zio.aws.wafregional.model.IPSetSummary]
  type IPSetUpdates = List[zio.aws.wafregional.model.IPSetUpdate]
  type LogDestinationConfigs = List[ResourceArn]
  type LoggingConfigurations =
    List[zio.aws.wafregional.model.LoggingConfiguration]
  type ManagedKeys = List[ManagedKey]
  type Predicates = List[zio.aws.wafregional.model.Predicate]
  type RedactedFields = List[zio.aws.wafregional.model.FieldToMatch]
  type RegexMatchSetSummaries =
    List[zio.aws.wafregional.model.RegexMatchSetSummary]
  type RegexMatchSetUpdates =
    List[zio.aws.wafregional.model.RegexMatchSetUpdate]
  type RegexMatchTuples = List[zio.aws.wafregional.model.RegexMatchTuple]
  type RegexPatternSetSummaries =
    List[zio.aws.wafregional.model.RegexPatternSetSummary]
  type RegexPatternSetUpdates =
    List[zio.aws.wafregional.model.RegexPatternSetUpdate]
  type RegexPatternStrings = List[RegexPatternString]
  type ResourceArns = List[ResourceArn]
  type RuleGroupSummaries = List[zio.aws.wafregional.model.RuleGroupSummary]
  type RuleGroupUpdates = List[zio.aws.wafregional.model.RuleGroupUpdate]
  type RuleSummaries = List[zio.aws.wafregional.model.RuleSummary]
  type RuleUpdates = List[zio.aws.wafregional.model.RuleUpdate]
  type SampledHTTPRequests = List[zio.aws.wafregional.model.SampledHTTPRequest]
  type SizeConstraintSetSummaries =
    List[zio.aws.wafregional.model.SizeConstraintSetSummary]
  type SizeConstraintSetUpdates =
    List[zio.aws.wafregional.model.SizeConstraintSetUpdate]
  type SizeConstraints = List[zio.aws.wafregional.model.SizeConstraint]
  type SqlInjectionMatchSetSummaries =
    List[zio.aws.wafregional.model.SqlInjectionMatchSetSummary]
  type SqlInjectionMatchSetUpdates =
    List[zio.aws.wafregional.model.SqlInjectionMatchSetUpdate]
  type SqlInjectionMatchTuples =
    List[zio.aws.wafregional.model.SqlInjectionMatchTuple]
  type SubscribedRuleGroupSummaries =
    List[zio.aws.wafregional.model.SubscribedRuleGroupSummary]
  type TagKeyList = List[TagKey]
  type TagList = List[zio.aws.wafregional.model.Tag]
  type WebACLSummaries = List[zio.aws.wafregional.model.WebACLSummary]
  type WebACLUpdates = List[zio.aws.wafregional.model.WebACLUpdate]
  type XssMatchSetSummaries = List[zio.aws.wafregional.model.XssMatchSetSummary]
  type XssMatchSetUpdates = List[zio.aws.wafregional.model.XssMatchSetUpdate]
  type XssMatchTuples = List[zio.aws.wafregional.model.XssMatchTuple]
}
