package zio.aws.wafregional.model
import zio.aws.wafregional.model.primitives.ResourceId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetRegexPatternSetRequest(regexPatternSetId: ResourceId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.GetRegexPatternSetRequest = {
    import GetRegexPatternSetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.GetRegexPatternSetRequest
      .builder()
      .regexPatternSetId(ResourceId.unwrap(regexPatternSetId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.wafregional.model.GetRegexPatternSetRequest.ReadOnly =
    zio.aws.wafregional.model.GetRegexPatternSetRequest.wrap(buildAwsValue())
}
object GetRegexPatternSetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.GetRegexPatternSetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafregional.model.GetRegexPatternSetRequest =
      zio.aws.wafregional.model.GetRegexPatternSetRequest(regexPatternSetId)
    def regexPatternSetId: ResourceId
    def getRegexPatternSetId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(regexPatternSetId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.GetRegexPatternSetRequest
  ) extends zio.aws.wafregional.model.GetRegexPatternSetRequest.ReadOnly {
    override val regexPatternSetId: ResourceId =
      zio.aws.wafregional.model.primitives.ResourceId(impl.regexPatternSetId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.GetRegexPatternSetRequest
  ): zio.aws.wafregional.model.GetRegexPatternSetRequest.ReadOnly = new Wrapper(
    impl
  )
}
