package zio.aws.wafregional.model
import zio.aws.wafregional.model.primitives.{ChangeToken, ResourceName}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CreateIpSetRequest(
    name: ResourceName,
    changeToken: ChangeToken
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.CreateIpSetRequest = {
    import CreateIpSetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.CreateIpSetRequest
      .builder()
      .name(ResourceName.unwrap(name): java.lang.String)
      .changeToken(ChangeToken.unwrap(changeToken): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.wafregional.model.CreateIpSetRequest.ReadOnly =
    zio.aws.wafregional.model.CreateIpSetRequest.wrap(buildAwsValue())
}
object CreateIpSetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.CreateIpSetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafregional.model.CreateIpSetRequest =
      zio.aws.wafregional.model.CreateIpSetRequest(name, changeToken)
    def name: ResourceName
    def changeToken: ChangeToken
    def getName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(name)
    def getChangeToken: ZIO[Any, Nothing, ChangeToken] =
      ZIO.succeed(changeToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.CreateIpSetRequest
  ) extends zio.aws.wafregional.model.CreateIpSetRequest.ReadOnly {
    override val name: ResourceName =
      zio.aws.wafregional.model.primitives.ResourceName(impl.name())
    override val changeToken: ChangeToken =
      zio.aws.wafregional.model.primitives.ChangeToken(impl.changeToken())
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.CreateIpSetRequest
  ): zio.aws.wafregional.model.CreateIpSetRequest.ReadOnly = new Wrapper(impl)
}
