package zio.aws.wafregional.model
import zio.aws.wafregional.model.primitives.ChangeToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateWebAclResponse(changeToken: Option[ChangeToken] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.UpdateWebAclResponse = {
    import UpdateWebAclResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.UpdateWebAclResponse
      .builder()
      .optionallyWith(
        changeToken.map(value => ChangeToken.unwrap(value): java.lang.String)
      )(_.changeToken)
      .build()
  }
  def asReadOnly: zio.aws.wafregional.model.UpdateWebAclResponse.ReadOnly =
    zio.aws.wafregional.model.UpdateWebAclResponse.wrap(buildAwsValue())
}
object UpdateWebAclResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.UpdateWebAclResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafregional.model.UpdateWebAclResponse =
      zio.aws.wafregional.model
        .UpdateWebAclResponse(changeToken.map(value => value))
    def changeToken: Option[ChangeToken]
    def getChangeToken: ZIO[Any, AwsError, ChangeToken] =
      AwsError.unwrapOptionField("changeToken", changeToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.UpdateWebAclResponse
  ) extends zio.aws.wafregional.model.UpdateWebAclResponse.ReadOnly {
    override val changeToken: Option[ChangeToken] = scala
      .Option(impl.changeToken())
      .map(value => zio.aws.wafregional.model.primitives.ChangeToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.UpdateWebAclResponse
  ): zio.aws.wafregional.model.UpdateWebAclResponse.ReadOnly = new Wrapper(impl)
}
