package zio.aws.wafregional.model
import zio.aws.wafregional.model.primitives.ResourceArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListResourcesForWebAclResponse(
    resourceArns: Option[Iterable[ResourceArn]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.ListResourcesForWebAclResponse = {
    import ListResourcesForWebAclResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.ListResourcesForWebAclResponse
      .builder()
      .optionallyWith(
        resourceArns.map(value =>
          value.map { item =>
            ResourceArn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.resourceArns)
      .build()
  }
  def asReadOnly
      : zio.aws.wafregional.model.ListResourcesForWebAclResponse.ReadOnly =
    zio.aws.wafregional.model.ListResourcesForWebAclResponse
      .wrap(buildAwsValue())
}
object ListResourcesForWebAclResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.ListResourcesForWebAclResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafregional.model.ListResourcesForWebAclResponse =
      zio.aws.wafregional.model
        .ListResourcesForWebAclResponse(resourceArns.map(value => value))
    def resourceArns: Option[List[ResourceArn]]
    def getResourceArns: ZIO[Any, AwsError, List[ResourceArn]] =
      AwsError.unwrapOptionField("resourceArns", resourceArns)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.ListResourcesForWebAclResponse
  ) extends zio.aws.wafregional.model.ListResourcesForWebAclResponse.ReadOnly {
    override val resourceArns: Option[List[ResourceArn]] = scala
      .Option(impl.resourceArns())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.wafregional.model.primitives.ResourceArn(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.ListResourcesForWebAclResponse
  ): zio.aws.wafregional.model.ListResourcesForWebAclResponse.ReadOnly =
    new Wrapper(impl)
}
