package zio.aws.wafregional.model
import zio.aws.wafregional.model.primitives.NextMarker
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListRateBasedRulesResponse(
    nextMarker: Option[NextMarker] = None,
    rules: Option[Iterable[zio.aws.wafregional.model.RuleSummary]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.ListRateBasedRulesResponse = {
    import ListRateBasedRulesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.ListRateBasedRulesResponse
      .builder()
      .optionallyWith(
        nextMarker.map(value => NextMarker.unwrap(value): java.lang.String)
      )(_.nextMarker)
      .optionallyWith(
        rules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.rules)
      .build()
  }
  def asReadOnly
      : zio.aws.wafregional.model.ListRateBasedRulesResponse.ReadOnly =
    zio.aws.wafregional.model.ListRateBasedRulesResponse.wrap(buildAwsValue())
}
object ListRateBasedRulesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.ListRateBasedRulesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafregional.model.ListRateBasedRulesResponse =
      zio.aws.wafregional.model.ListRateBasedRulesResponse(
        nextMarker.map(value => value),
        rules.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextMarker: Option[NextMarker]
    def rules: Option[List[zio.aws.wafregional.model.RuleSummary.ReadOnly]]
    def getNextMarker: ZIO[Any, AwsError, NextMarker] =
      AwsError.unwrapOptionField("nextMarker", nextMarker)
    def getRules: ZIO[Any, AwsError, List[
      zio.aws.wafregional.model.RuleSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("rules", rules)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.ListRateBasedRulesResponse
  ) extends zio.aws.wafregional.model.ListRateBasedRulesResponse.ReadOnly {
    override val nextMarker: Option[NextMarker] = scala
      .Option(impl.nextMarker())
      .map(value => zio.aws.wafregional.model.primitives.NextMarker(value))
    override val rules
        : Option[List[zio.aws.wafregional.model.RuleSummary.ReadOnly]] = scala
      .Option(impl.rules())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.wafregional.model.RuleSummary.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.ListRateBasedRulesResponse
  ): zio.aws.wafregional.model.ListRateBasedRulesResponse.ReadOnly =
    new Wrapper(impl)
}
