package zio.aws.wafregional.model
import zio.aws.wafregional.model.primitives.{ChangeToken, ResourceId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteXssMatchSetRequest(
    xssMatchSetId: ResourceId,
    changeToken: ChangeToken
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.DeleteXssMatchSetRequest = {
    import DeleteXssMatchSetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.DeleteXssMatchSetRequest
      .builder()
      .xssMatchSetId(ResourceId.unwrap(xssMatchSetId): java.lang.String)
      .changeToken(ChangeToken.unwrap(changeToken): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.wafregional.model.DeleteXssMatchSetRequest.ReadOnly =
    zio.aws.wafregional.model.DeleteXssMatchSetRequest.wrap(buildAwsValue())
}
object DeleteXssMatchSetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.DeleteXssMatchSetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafregional.model.DeleteXssMatchSetRequest =
      zio.aws.wafregional.model
        .DeleteXssMatchSetRequest(xssMatchSetId, changeToken)
    def xssMatchSetId: ResourceId
    def changeToken: ChangeToken
    def getXssMatchSetId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(xssMatchSetId)
    def getChangeToken: ZIO[Any, Nothing, ChangeToken] =
      ZIO.succeed(changeToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.DeleteXssMatchSetRequest
  ) extends zio.aws.wafregional.model.DeleteXssMatchSetRequest.ReadOnly {
    override val xssMatchSetId: ResourceId =
      zio.aws.wafregional.model.primitives.ResourceId(impl.xssMatchSetId())
    override val changeToken: ChangeToken =
      zio.aws.wafregional.model.primitives.ChangeToken(impl.changeToken())
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.DeleteXssMatchSetRequest
  ): zio.aws.wafregional.model.DeleteXssMatchSetRequest.ReadOnly = new Wrapper(
    impl
  )
}
