package zio.aws.wafregional.model
import zio.aws.wafregional.model.primitives.{ChangeToken, ResourceId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteSizeConstraintSetRequest(
    sizeConstraintSetId: ResourceId,
    changeToken: ChangeToken
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.DeleteSizeConstraintSetRequest = {
    import DeleteSizeConstraintSetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.DeleteSizeConstraintSetRequest
      .builder()
      .sizeConstraintSetId(
        ResourceId.unwrap(sizeConstraintSetId): java.lang.String
      )
      .changeToken(ChangeToken.unwrap(changeToken): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.wafregional.model.DeleteSizeConstraintSetRequest.ReadOnly =
    zio.aws.wafregional.model.DeleteSizeConstraintSetRequest
      .wrap(buildAwsValue())
}
object DeleteSizeConstraintSetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.DeleteSizeConstraintSetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafregional.model.DeleteSizeConstraintSetRequest =
      zio.aws.wafregional.model
        .DeleteSizeConstraintSetRequest(sizeConstraintSetId, changeToken)
    def sizeConstraintSetId: ResourceId
    def changeToken: ChangeToken
    def getSizeConstraintSetId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(sizeConstraintSetId)
    def getChangeToken: ZIO[Any, Nothing, ChangeToken] =
      ZIO.succeed(changeToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.DeleteSizeConstraintSetRequest
  ) extends zio.aws.wafregional.model.DeleteSizeConstraintSetRequest.ReadOnly {
    override val sizeConstraintSetId: ResourceId =
      zio.aws.wafregional.model.primitives
        .ResourceId(impl.sizeConstraintSetId())
    override val changeToken: ChangeToken =
      zio.aws.wafregional.model.primitives.ChangeToken(impl.changeToken())
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.DeleteSizeConstraintSetRequest
  ): zio.aws.wafregional.model.DeleteSizeConstraintSetRequest.ReadOnly =
    new Wrapper(impl)
}
