package zio.aws.wafregional.model
import zio.aws.wafregional.model.primitives.ChangeToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateIpSetResponse(
    ipSet: Option[zio.aws.wafregional.model.IPSet] = None,
    changeToken: Option[ChangeToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.CreateIpSetResponse = {
    import CreateIpSetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.CreateIpSetResponse
      .builder()
      .optionallyWith(ipSet.map(value => value.buildAwsValue()))(_.ipSet)
      .optionallyWith(
        changeToken.map(value => ChangeToken.unwrap(value): java.lang.String)
      )(_.changeToken)
      .build()
  }
  def asReadOnly: zio.aws.wafregional.model.CreateIpSetResponse.ReadOnly =
    zio.aws.wafregional.model.CreateIpSetResponse.wrap(buildAwsValue())
}
object CreateIpSetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.CreateIpSetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafregional.model.CreateIpSetResponse =
      zio.aws.wafregional.model.CreateIpSetResponse(
        ipSet.map(value => value.asEditable),
        changeToken.map(value => value)
      )
    def ipSet: Option[zio.aws.wafregional.model.IPSet.ReadOnly]
    def changeToken: Option[ChangeToken]
    def getIpSet: ZIO[Any, AwsError, zio.aws.wafregional.model.IPSet.ReadOnly] =
      AwsError.unwrapOptionField("ipSet", ipSet)
    def getChangeToken: ZIO[Any, AwsError, ChangeToken] =
      AwsError.unwrapOptionField("changeToken", changeToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.CreateIpSetResponse
  ) extends zio.aws.wafregional.model.CreateIpSetResponse.ReadOnly {
    override val ipSet: Option[zio.aws.wafregional.model.IPSet.ReadOnly] = scala
      .Option(impl.ipSet())
      .map(value => zio.aws.wafregional.model.IPSet.wrap(value))
    override val changeToken: Option[ChangeToken] = scala
      .Option(impl.changeToken())
      .map(value => zio.aws.wafregional.model.primitives.ChangeToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.CreateIpSetResponse
  ): zio.aws.wafregional.model.CreateIpSetResponse.ReadOnly = new Wrapper(impl)
}
