package zio.aws.wafregional.model
import zio.aws.wafregional.model.primitives.ChangeToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateByteMatchSetResponse(
    byteMatchSet: Option[zio.aws.wafregional.model.ByteMatchSet] = None,
    changeToken: Option[ChangeToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.CreateByteMatchSetResponse = {
    import CreateByteMatchSetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.CreateByteMatchSetResponse
      .builder()
      .optionallyWith(byteMatchSet.map(value => value.buildAwsValue()))(
        _.byteMatchSet
      )
      .optionallyWith(
        changeToken.map(value => ChangeToken.unwrap(value): java.lang.String)
      )(_.changeToken)
      .build()
  }
  def asReadOnly
      : zio.aws.wafregional.model.CreateByteMatchSetResponse.ReadOnly =
    zio.aws.wafregional.model.CreateByteMatchSetResponse.wrap(buildAwsValue())
}
object CreateByteMatchSetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.CreateByteMatchSetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafregional.model.CreateByteMatchSetResponse =
      zio.aws.wafregional.model.CreateByteMatchSetResponse(
        byteMatchSet.map(value => value.asEditable),
        changeToken.map(value => value)
      )
    def byteMatchSet: Option[zio.aws.wafregional.model.ByteMatchSet.ReadOnly]
    def changeToken: Option[ChangeToken]
    def getByteMatchSet
        : ZIO[Any, AwsError, zio.aws.wafregional.model.ByteMatchSet.ReadOnly] =
      AwsError.unwrapOptionField("byteMatchSet", byteMatchSet)
    def getChangeToken: ZIO[Any, AwsError, ChangeToken] =
      AwsError.unwrapOptionField("changeToken", changeToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.CreateByteMatchSetResponse
  ) extends zio.aws.wafregional.model.CreateByteMatchSetResponse.ReadOnly {
    override val byteMatchSet
        : Option[zio.aws.wafregional.model.ByteMatchSet.ReadOnly] = scala
      .Option(impl.byteMatchSet())
      .map(value => zio.aws.wafregional.model.ByteMatchSet.wrap(value))
    override val changeToken: Option[ChangeToken] = scala
      .Option(impl.changeToken())
      .map(value => zio.aws.wafregional.model.primitives.ChangeToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.CreateByteMatchSetResponse
  ): zio.aws.wafregional.model.CreateByteMatchSetResponse.ReadOnly =
    new Wrapper(impl)
}
