package zio.aws.wafregional.model
import zio.aws.wafregional.model.primitives.{ResourceName, ResourceId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class SqlInjectionMatchSetSummary(
    sqlInjectionMatchSetId: ResourceId,
    name: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.SqlInjectionMatchSetSummary = {
    import SqlInjectionMatchSetSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.SqlInjectionMatchSetSummary
      .builder()
      .sqlInjectionMatchSetId(
        ResourceId.unwrap(sqlInjectionMatchSetId): java.lang.String
      )
      .name(ResourceName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.wafregional.model.SqlInjectionMatchSetSummary.ReadOnly =
    zio.aws.wafregional.model.SqlInjectionMatchSetSummary.wrap(buildAwsValue())
}
object SqlInjectionMatchSetSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.SqlInjectionMatchSetSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafregional.model.SqlInjectionMatchSetSummary =
      zio.aws.wafregional.model
        .SqlInjectionMatchSetSummary(sqlInjectionMatchSetId, name)
    def sqlInjectionMatchSetId: ResourceId
    def name: ResourceName
    def getSqlInjectionMatchSetId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(sqlInjectionMatchSetId)
    def getName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.SqlInjectionMatchSetSummary
  ) extends zio.aws.wafregional.model.SqlInjectionMatchSetSummary.ReadOnly {
    override val sqlInjectionMatchSetId: ResourceId =
      zio.aws.wafregional.model.primitives
        .ResourceId(impl.sqlInjectionMatchSetId())
    override val name: ResourceName =
      zio.aws.wafregional.model.primitives.ResourceName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.SqlInjectionMatchSetSummary
  ): zio.aws.wafregional.model.SqlInjectionMatchSetSummary.ReadOnly =
    new Wrapper(impl)
}
