package zio.aws.wafregional.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class RuleUpdate(
    action: zio.aws.wafregional.model.ChangeAction,
    predicate: zio.aws.wafregional.model.Predicate
) {
  def buildAwsValue(): software.amazon.awssdk.services.waf.model.RuleUpdate = {
    import RuleUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.RuleUpdate
      .builder()
      .action(action.unwrap)
      .predicate(predicate.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.wafregional.model.RuleUpdate.ReadOnly =
    zio.aws.wafregional.model.RuleUpdate.wrap(buildAwsValue())
}
object RuleUpdate {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.waf.model.RuleUpdate] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafregional.model.RuleUpdate =
      zio.aws.wafregional.model.RuleUpdate(action, predicate.asEditable)
    def action: zio.aws.wafregional.model.ChangeAction
    def predicate: zio.aws.wafregional.model.Predicate.ReadOnly
    def getAction: ZIO[Any, Nothing, zio.aws.wafregional.model.ChangeAction] =
      ZIO.succeed(action)
    def getPredicate
        : ZIO[Any, Nothing, zio.aws.wafregional.model.Predicate.ReadOnly] =
      ZIO.succeed(predicate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.RuleUpdate
  ) extends zio.aws.wafregional.model.RuleUpdate.ReadOnly {
    override val action: zio.aws.wafregional.model.ChangeAction =
      zio.aws.wafregional.model.ChangeAction.wrap(impl.action())
    override val predicate: zio.aws.wafregional.model.Predicate.ReadOnly =
      zio.aws.wafregional.model.Predicate.wrap(impl.predicate())
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.RuleUpdate
  ): zio.aws.wafregional.model.RuleUpdate.ReadOnly = new Wrapper(impl)
}
