package zio.aws.wafregional.model
import zio.aws.wafregional.model.primitives.{
  RateLimit,
  MetricName,
  ResourceName,
  ResourceId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class RateBasedRule(
    ruleId: ResourceId,
    name: Option[ResourceName] = None,
    metricName: Option[MetricName] = None,
    matchPredicates: Iterable[zio.aws.wafregional.model.Predicate],
    rateKey: zio.aws.wafregional.model.RateKey,
    rateLimit: RateLimit
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.RateBasedRule = {
    import RateBasedRule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.RateBasedRule
      .builder()
      .ruleId(ResourceId.unwrap(ruleId): java.lang.String)
      .optionallyWith(
        name.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        metricName.map(value => MetricName.unwrap(value): java.lang.String)
      )(_.metricName)
      .matchPredicates(matchPredicates.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .rateKey(rateKey.unwrap)
      .rateLimit(RateLimit.unwrap(rateLimit): java.lang.Long)
      .build()
  }
  def asReadOnly: zio.aws.wafregional.model.RateBasedRule.ReadOnly =
    zio.aws.wafregional.model.RateBasedRule.wrap(buildAwsValue())
}
object RateBasedRule {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.waf.model.RateBasedRule] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafregional.model.RateBasedRule =
      zio.aws.wafregional.model.RateBasedRule(
        ruleId,
        name.map(value => value),
        metricName.map(value => value),
        matchPredicates.map { item =>
          item.asEditable
        },
        rateKey,
        rateLimit
      )
    def ruleId: ResourceId
    def name: Option[ResourceName]
    def metricName: Option[MetricName]
    def matchPredicates: List[zio.aws.wafregional.model.Predicate.ReadOnly]
    def rateKey: zio.aws.wafregional.model.RateKey
    def rateLimit: RateLimit
    def getRuleId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(ruleId)
    def getName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("name", name)
    def getMetricName: ZIO[Any, AwsError, MetricName] =
      AwsError.unwrapOptionField("metricName", metricName)
    def getMatchPredicates: ZIO[Any, Nothing, List[
      zio.aws.wafregional.model.Predicate.ReadOnly
    ]] = ZIO.succeed(matchPredicates)
    def getRateKey: ZIO[Any, Nothing, zio.aws.wafregional.model.RateKey] =
      ZIO.succeed(rateKey)
    def getRateLimit: ZIO[Any, Nothing, RateLimit] = ZIO.succeed(rateLimit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.RateBasedRule
  ) extends zio.aws.wafregional.model.RateBasedRule.ReadOnly {
    override val ruleId: ResourceId =
      zio.aws.wafregional.model.primitives.ResourceId(impl.ruleId())
    override val name: Option[ResourceName] = scala
      .Option(impl.name())
      .map(value => zio.aws.wafregional.model.primitives.ResourceName(value))
    override val metricName: Option[MetricName] = scala
      .Option(impl.metricName())
      .map(value => zio.aws.wafregional.model.primitives.MetricName(value))
    override val matchPredicates
        : List[zio.aws.wafregional.model.Predicate.ReadOnly] = impl
      .matchPredicates()
      .asScala
      .map { item =>
        zio.aws.wafregional.model.Predicate.wrap(item)
      }
      .toList
    override val rateKey: zio.aws.wafregional.model.RateKey =
      zio.aws.wafregional.model.RateKey.wrap(impl.rateKey())
    override val rateLimit: RateLimit =
      zio.aws.wafregional.model.primitives.RateLimit(impl.rateLimit())
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.RateBasedRule
  ): zio.aws.wafregional.model.RateBasedRule.ReadOnly = new Wrapper(impl)
}
