package zio.aws.wafregional.model
import zio.aws.wafregional.model.primitives.ChangeToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateRegexPatternSetResponse(
    regexPatternSet: Option[zio.aws.wafregional.model.RegexPatternSet] = None,
    changeToken: Option[ChangeToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.CreateRegexPatternSetResponse = {
    import CreateRegexPatternSetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.CreateRegexPatternSetResponse
      .builder()
      .optionallyWith(regexPatternSet.map(value => value.buildAwsValue()))(
        _.regexPatternSet
      )
      .optionallyWith(
        changeToken.map(value => ChangeToken.unwrap(value): java.lang.String)
      )(_.changeToken)
      .build()
  }
  def asReadOnly
      : zio.aws.wafregional.model.CreateRegexPatternSetResponse.ReadOnly =
    zio.aws.wafregional.model.CreateRegexPatternSetResponse
      .wrap(buildAwsValue())
}
object CreateRegexPatternSetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.CreateRegexPatternSetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafregional.model.CreateRegexPatternSetResponse =
      zio.aws.wafregional.model.CreateRegexPatternSetResponse(
        regexPatternSet.map(value => value.asEditable),
        changeToken.map(value => value)
      )
    def regexPatternSet
        : Option[zio.aws.wafregional.model.RegexPatternSet.ReadOnly]
    def changeToken: Option[ChangeToken]
    def getRegexPatternSet: ZIO[
      Any,
      AwsError,
      zio.aws.wafregional.model.RegexPatternSet.ReadOnly
    ] = AwsError.unwrapOptionField("regexPatternSet", regexPatternSet)
    def getChangeToken: ZIO[Any, AwsError, ChangeToken] =
      AwsError.unwrapOptionField("changeToken", changeToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.CreateRegexPatternSetResponse
  ) extends zio.aws.wafregional.model.CreateRegexPatternSetResponse.ReadOnly {
    override val regexPatternSet
        : Option[zio.aws.wafregional.model.RegexPatternSet.ReadOnly] = scala
      .Option(impl.regexPatternSet())
      .map(value => zio.aws.wafregional.model.RegexPatternSet.wrap(value))
    override val changeToken: Option[ChangeToken] = scala
      .Option(impl.changeToken())
      .map(value => zio.aws.wafregional.model.primitives.ChangeToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.CreateRegexPatternSetResponse
  ): zio.aws.wafregional.model.CreateRegexPatternSetResponse.ReadOnly =
    new Wrapper(impl)
}
