package zio.aws.wafregional.model
import zio.aws.wafregional.model.primitives.ChangeToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateRateBasedRuleResponse(
    rule: Option[zio.aws.wafregional.model.RateBasedRule] = None,
    changeToken: Option[ChangeToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.CreateRateBasedRuleResponse = {
    import CreateRateBasedRuleResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.CreateRateBasedRuleResponse
      .builder()
      .optionallyWith(rule.map(value => value.buildAwsValue()))(_.rule)
      .optionallyWith(
        changeToken.map(value => ChangeToken.unwrap(value): java.lang.String)
      )(_.changeToken)
      .build()
  }
  def asReadOnly
      : zio.aws.wafregional.model.CreateRateBasedRuleResponse.ReadOnly =
    zio.aws.wafregional.model.CreateRateBasedRuleResponse.wrap(buildAwsValue())
}
object CreateRateBasedRuleResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.CreateRateBasedRuleResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafregional.model.CreateRateBasedRuleResponse =
      zio.aws.wafregional.model.CreateRateBasedRuleResponse(
        rule.map(value => value.asEditable),
        changeToken.map(value => value)
      )
    def rule: Option[zio.aws.wafregional.model.RateBasedRule.ReadOnly]
    def changeToken: Option[ChangeToken]
    def getRule
        : ZIO[Any, AwsError, zio.aws.wafregional.model.RateBasedRule.ReadOnly] =
      AwsError.unwrapOptionField("rule", rule)
    def getChangeToken: ZIO[Any, AwsError, ChangeToken] =
      AwsError.unwrapOptionField("changeToken", changeToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.CreateRateBasedRuleResponse
  ) extends zio.aws.wafregional.model.CreateRateBasedRuleResponse.ReadOnly {
    override val rule
        : Option[zio.aws.wafregional.model.RateBasedRule.ReadOnly] = scala
      .Option(impl.rule())
      .map(value => zio.aws.wafregional.model.RateBasedRule.wrap(value))
    override val changeToken: Option[ChangeToken] = scala
      .Option(impl.changeToken())
      .map(value => zio.aws.wafregional.model.primitives.ChangeToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.CreateRateBasedRuleResponse
  ): zio.aws.wafregional.model.CreateRateBasedRuleResponse.ReadOnly =
    new Wrapper(impl)
}
