package zio.aws.wafregional
import zio.aws.wafregional.model.CreateSizeConstraintSetResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import software.amazon.awssdk.services.waf.regional.WafRegionalAsyncClient
import zio.aws.wafregional.model.{
  DeleteRateBasedRuleRequest,
  GetRateBasedRuleManagedKeysRequest,
  UpdateWebAclRequest,
  GetRuleGroupRequest,
  GetLoggingConfigurationRequest,
  UpdateByteMatchSetRequest,
  AssociateWebAclRequest,
  DeleteWebAclRequest,
  UpdateRateBasedRuleRequest,
  DeleteRuleGroupRequest,
  GetIpSetRequest,
  GetSizeConstraintSetRequest,
  GetPermissionPolicyRequest,
  DeleteSqlInjectionMatchSetRequest,
  UpdateIpSetRequest,
  GetXssMatchSetRequest,
  CreateByteMatchSetRequest,
  CreateXssMatchSetRequest,
  CreateWebAclMigrationStackRequest,
  ListRulesRequest,
  GetRuleRequest,
  PutPermissionPolicyRequest,
  GetChangeTokenRequest,
  UpdateSqlInjectionMatchSetRequest,
  DeleteRegexMatchSetRequest,
  ListTagsForResourceRequest,
  GetRegexPatternSetRequest,
  ListSizeConstraintSetsRequest,
  ListRuleGroupsRequest,
  PutLoggingConfigurationRequest,
  ListLoggingConfigurationsRequest,
  ListActivatedRulesInRuleGroupRequest,
  DeleteIpSetRequest,
  GetRegexMatchSetRequest,
  ListRegexMatchSetsRequest,
  DeletePermissionPolicyRequest,
  CreateGeoMatchSetRequest,
  CreateRuleRequest,
  GetGeoMatchSetRequest,
  GetWebAclRequest,
  DeleteLoggingConfigurationRequest,
  UpdateGeoMatchSetRequest,
  DeleteXssMatchSetRequest,
  GetSqlInjectionMatchSetRequest,
  ListSubscribedRuleGroupsRequest,
  DeleteRuleRequest,
  ListGeoMatchSetsRequest,
  GetRateBasedRuleRequest,
  DisassociateWebAclRequest,
  DeleteRegexPatternSetRequest,
  CreateRegexPatternSetRequest,
  GetSampledRequestsRequest,
  DeleteByteMatchSetRequest,
  UpdateRuleGroupRequest,
  ListResourcesForWebAclRequest,
  UntagResourceRequest,
  CreateRuleGroupRequest,
  GetByteMatchSetRequest,
  CreateSqlInjectionMatchSetRequest,
  CreateRateBasedRuleRequest,
  DeleteSizeConstraintSetRequest,
  CreateRegexMatchSetRequest,
  ListXssMatchSetsRequest,
  UpdateRuleRequest,
  GetWebAclForResourceRequest,
  UpdateRegexMatchSetRequest,
  DeleteGeoMatchSetRequest,
  CreateSizeConstraintSetRequest,
  GetChangeTokenStatusRequest,
  ListRateBasedRulesRequest,
  ListByteMatchSetsRequest,
  UpdateXssMatchSetRequest,
  UpdateRegexPatternSetRequest,
  UpdateSizeConstraintSetRequest,
  ListSqlInjectionMatchSetsRequest,
  TagResourceRequest,
  ListWebAcLsRequest,
  CreateWebAclRequest,
  ListRegexPatternSetsRequest,
  ListIpSetsRequest,
  CreateIpSetRequest
}
object WafRegionalMock extends Mock[WafRegional] {
  object ListXssMatchSets
      extends Effect[
        ListXssMatchSetsRequest,
        AwsError,
        zio.aws.wafregional.model.ListXssMatchSetsResponse.ReadOnly
      ]
  object GetRuleGroup
      extends Effect[
        GetRuleGroupRequest,
        AwsError,
        zio.aws.wafregional.model.GetRuleGroupResponse.ReadOnly
      ]
  object ListGeoMatchSets
      extends Effect[
        ListGeoMatchSetsRequest,
        AwsError,
        zio.aws.wafregional.model.ListGeoMatchSetsResponse.ReadOnly
      ]
  object UpdateByteMatchSet
      extends Effect[
        UpdateByteMatchSetRequest,
        AwsError,
        zio.aws.wafregional.model.UpdateByteMatchSetResponse.ReadOnly
      ]
  object UpdateRegexMatchSet
      extends Effect[
        UpdateRegexMatchSetRequest,
        AwsError,
        zio.aws.wafregional.model.UpdateRegexMatchSetResponse.ReadOnly
      ]
  object CreateRegexMatchSet
      extends Effect[
        CreateRegexMatchSetRequest,
        AwsError,
        zio.aws.wafregional.model.CreateRegexMatchSetResponse.ReadOnly
      ]
  object GetWebACL
      extends Effect[
        GetWebAclRequest,
        AwsError,
        zio.aws.wafregional.model.GetWebAclResponse.ReadOnly
      ]
  object GetRateBasedRule
      extends Effect[
        GetRateBasedRuleRequest,
        AwsError,
        zio.aws.wafregional.model.GetRateBasedRuleResponse.ReadOnly
      ]
  object ListSizeConstraintSets
      extends Effect[
        ListSizeConstraintSetsRequest,
        AwsError,
        zio.aws.wafregional.model.ListSizeConstraintSetsResponse.ReadOnly
      ]
  object ListRegexMatchSets
      extends Effect[
        ListRegexMatchSetsRequest,
        AwsError,
        zio.aws.wafregional.model.ListRegexMatchSetsResponse.ReadOnly
      ]
  object GetRegexMatchSet
      extends Effect[
        GetRegexMatchSetRequest,
        AwsError,
        zio.aws.wafregional.model.GetRegexMatchSetResponse.ReadOnly
      ]
  object ListSubscribedRuleGroups
      extends Effect[
        ListSubscribedRuleGroupsRequest,
        AwsError,
        zio.aws.wafregional.model.ListSubscribedRuleGroupsResponse.ReadOnly
      ]
  object GetSqlInjectionMatchSet
      extends Effect[
        GetSqlInjectionMatchSetRequest,
        AwsError,
        zio.aws.wafregional.model.GetSqlInjectionMatchSetResponse.ReadOnly
      ]
  object GetIPSet
      extends Effect[
        GetIpSetRequest,
        AwsError,
        zio.aws.wafregional.model.GetIpSetResponse.ReadOnly
      ]
  object CreateRuleGroup
      extends Effect[
        CreateRuleGroupRequest,
        AwsError,
        zio.aws.wafregional.model.CreateRuleGroupResponse.ReadOnly
      ]
  object ListRuleGroups
      extends Effect[
        ListRuleGroupsRequest,
        AwsError,
        zio.aws.wafregional.model.ListRuleGroupsResponse.ReadOnly
      ]
  object DeleteRegexPatternSet
      extends Effect[
        DeleteRegexPatternSetRequest,
        AwsError,
        zio.aws.wafregional.model.DeleteRegexPatternSetResponse.ReadOnly
      ]
  object UpdateRateBasedRule
      extends Effect[
        UpdateRateBasedRuleRequest,
        AwsError,
        zio.aws.wafregional.model.UpdateRateBasedRuleResponse.ReadOnly
      ]
  object DisassociateWebACL
      extends Effect[
        DisassociateWebAclRequest,
        AwsError,
        zio.aws.wafregional.model.DisassociateWebAclResponse.ReadOnly
      ]
  object ListResourcesForWebACL
      extends Effect[
        ListResourcesForWebAclRequest,
        AwsError,
        zio.aws.wafregional.model.ListResourcesForWebAclResponse.ReadOnly
      ]
  object UpdateSqlInjectionMatchSet
      extends Effect[
        UpdateSqlInjectionMatchSetRequest,
        AwsError,
        zio.aws.wafregional.model.UpdateSqlInjectionMatchSetResponse.ReadOnly
      ]
  object DeleteGeoMatchSet
      extends Effect[
        DeleteGeoMatchSetRequest,
        AwsError,
        zio.aws.wafregional.model.DeleteGeoMatchSetResponse.ReadOnly
      ]
  object CreateIPSet
      extends Effect[
        CreateIpSetRequest,
        AwsError,
        zio.aws.wafregional.model.CreateIpSetResponse.ReadOnly
      ]
  object GetWebACLForResource
      extends Effect[
        GetWebAclForResourceRequest,
        AwsError,
        zio.aws.wafregional.model.GetWebAclForResourceResponse.ReadOnly
      ]
  object GetRateBasedRuleManagedKeys
      extends Effect[
        GetRateBasedRuleManagedKeysRequest,
        AwsError,
        zio.aws.wafregional.model.GetRateBasedRuleManagedKeysResponse.ReadOnly
      ]
  object UpdateGeoMatchSet
      extends Effect[
        UpdateGeoMatchSetRequest,
        AwsError,
        zio.aws.wafregional.model.UpdateGeoMatchSetResponse.ReadOnly
      ]
  object ListRegexPatternSets
      extends Effect[
        ListRegexPatternSetsRequest,
        AwsError,
        zio.aws.wafregional.model.ListRegexPatternSetsResponse.ReadOnly
      ]
  object ListByteMatchSets
      extends Effect[
        ListByteMatchSetsRequest,
        AwsError,
        zio.aws.wafregional.model.ListByteMatchSetsResponse.ReadOnly
      ]
  object UpdateIPSet
      extends Effect[
        UpdateIpSetRequest,
        AwsError,
        zio.aws.wafregional.model.UpdateIpSetResponse.ReadOnly
      ]
  object CreateRateBasedRule
      extends Effect[
        CreateRateBasedRuleRequest,
        AwsError,
        zio.aws.wafregional.model.CreateRateBasedRuleResponse.ReadOnly
      ]
  object DeleteXssMatchSet
      extends Effect[
        DeleteXssMatchSetRequest,
        AwsError,
        zio.aws.wafregional.model.DeleteXssMatchSetResponse.ReadOnly
      ]
  object GetByteMatchSet
      extends Effect[
        GetByteMatchSetRequest,
        AwsError,
        zio.aws.wafregional.model.GetByteMatchSetResponse.ReadOnly
      ]
  object DeleteRule
      extends Effect[
        DeleteRuleRequest,
        AwsError,
        zio.aws.wafregional.model.DeleteRuleResponse.ReadOnly
      ]
  object GetSizeConstraintSet
      extends Effect[
        GetSizeConstraintSetRequest,
        AwsError,
        zio.aws.wafregional.model.GetSizeConstraintSetResponse.ReadOnly
      ]
  object CreateByteMatchSet
      extends Effect[
        CreateByteMatchSetRequest,
        AwsError,
        zio.aws.wafregional.model.CreateByteMatchSetResponse.ReadOnly
      ]
  object UpdateRule
      extends Effect[
        UpdateRuleRequest,
        AwsError,
        zio.aws.wafregional.model.UpdateRuleResponse.ReadOnly
      ]
  object AssociateWebACL
      extends Effect[
        AssociateWebAclRequest,
        AwsError,
        zio.aws.wafregional.model.AssociateWebAclResponse.ReadOnly
      ]
  object GetRegexPatternSet
      extends Effect[
        GetRegexPatternSetRequest,
        AwsError,
        zio.aws.wafregional.model.GetRegexPatternSetResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.wafregional.model.UntagResourceResponse.ReadOnly
      ]
  object DeleteRateBasedRule
      extends Effect[
        DeleteRateBasedRuleRequest,
        AwsError,
        zio.aws.wafregional.model.DeleteRateBasedRuleResponse.ReadOnly
      ]
  object PutLoggingConfiguration
      extends Effect[
        PutLoggingConfigurationRequest,
        AwsError,
        zio.aws.wafregional.model.PutLoggingConfigurationResponse.ReadOnly
      ]
  object GetXssMatchSet
      extends Effect[
        GetXssMatchSetRequest,
        AwsError,
        zio.aws.wafregional.model.GetXssMatchSetResponse.ReadOnly
      ]
  object DeleteWebACL
      extends Effect[
        DeleteWebAclRequest,
        AwsError,
        zio.aws.wafregional.model.DeleteWebAclResponse.ReadOnly
      ]
  object CreateRegexPatternSet
      extends Effect[
        CreateRegexPatternSetRequest,
        AwsError,
        zio.aws.wafregional.model.CreateRegexPatternSetResponse.ReadOnly
      ]
  object ListWebACLs
      extends Effect[
        ListWebAcLsRequest,
        AwsError,
        zio.aws.wafregional.model.ListWebAcLsResponse.ReadOnly
      ]
  object PutPermissionPolicy
      extends Effect[
        PutPermissionPolicyRequest,
        AwsError,
        zio.aws.wafregional.model.PutPermissionPolicyResponse.ReadOnly
      ]
  object CreateXssMatchSet
      extends Effect[
        CreateXssMatchSetRequest,
        AwsError,
        zio.aws.wafregional.model.CreateXssMatchSetResponse.ReadOnly
      ]
  object GetChangeTokenStatus
      extends Effect[
        GetChangeTokenStatusRequest,
        AwsError,
        zio.aws.wafregional.model.GetChangeTokenStatusResponse.ReadOnly
      ]
  object CreateSizeConstraintSet
      extends Effect[CreateSizeConstraintSetRequest, AwsError, ReadOnly]
  object GetLoggingConfiguration
      extends Effect[
        GetLoggingConfigurationRequest,
        AwsError,
        zio.aws.wafregional.model.GetLoggingConfigurationResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.wafregional.model.ListTagsForResourceResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.wafregional.model.TagResourceResponse.ReadOnly
      ]
  object ListRules
      extends Effect[
        ListRulesRequest,
        AwsError,
        zio.aws.wafregional.model.ListRulesResponse.ReadOnly
      ]
  object ListLoggingConfigurations
      extends Effect[
        ListLoggingConfigurationsRequest,
        AwsError,
        zio.aws.wafregional.model.ListLoggingConfigurationsResponse.ReadOnly
      ]
  object UpdateXssMatchSet
      extends Effect[
        UpdateXssMatchSetRequest,
        AwsError,
        zio.aws.wafregional.model.UpdateXssMatchSetResponse.ReadOnly
      ]
  object DeleteLoggingConfiguration
      extends Effect[
        DeleteLoggingConfigurationRequest,
        AwsError,
        zio.aws.wafregional.model.DeleteLoggingConfigurationResponse.ReadOnly
      ]
  object GetGeoMatchSet
      extends Effect[
        GetGeoMatchSetRequest,
        AwsError,
        zio.aws.wafregional.model.GetGeoMatchSetResponse.ReadOnly
      ]
  object UpdateSizeConstraintSet
      extends Effect[
        UpdateSizeConstraintSetRequest,
        AwsError,
        zio.aws.wafregional.model.UpdateSizeConstraintSetResponse.ReadOnly
      ]
  object ListRateBasedRules
      extends Effect[
        ListRateBasedRulesRequest,
        AwsError,
        zio.aws.wafregional.model.ListRateBasedRulesResponse.ReadOnly
      ]
  object UpdateRuleGroup
      extends Effect[
        UpdateRuleGroupRequest,
        AwsError,
        zio.aws.wafregional.model.UpdateRuleGroupResponse.ReadOnly
      ]
  object UpdateRegexPatternSet
      extends Effect[
        UpdateRegexPatternSetRequest,
        AwsError,
        zio.aws.wafregional.model.UpdateRegexPatternSetResponse.ReadOnly
      ]
  object CreateWebACL
      extends Effect[
        CreateWebAclRequest,
        AwsError,
        zio.aws.wafregional.model.CreateWebAclResponse.ReadOnly
      ]
  object CreateGeoMatchSet
      extends Effect[
        CreateGeoMatchSetRequest,
        AwsError,
        zio.aws.wafregional.model.CreateGeoMatchSetResponse.ReadOnly
      ]
  object GetPermissionPolicy
      extends Effect[
        GetPermissionPolicyRequest,
        AwsError,
        zio.aws.wafregional.model.GetPermissionPolicyResponse.ReadOnly
      ]
  object UpdateWebACL
      extends Effect[
        UpdateWebAclRequest,
        AwsError,
        zio.aws.wafregional.model.UpdateWebAclResponse.ReadOnly
      ]
  object DeleteRuleGroup
      extends Effect[
        DeleteRuleGroupRequest,
        AwsError,
        zio.aws.wafregional.model.DeleteRuleGroupResponse.ReadOnly
      ]
  object DeleteByteMatchSet
      extends Effect[
        DeleteByteMatchSetRequest,
        AwsError,
        zio.aws.wafregional.model.DeleteByteMatchSetResponse.ReadOnly
      ]
  object GetChangeToken
      extends Effect[
        GetChangeTokenRequest,
        AwsError,
        zio.aws.wafregional.model.GetChangeTokenResponse.ReadOnly
      ]
  object DeleteRegexMatchSet
      extends Effect[
        DeleteRegexMatchSetRequest,
        AwsError,
        zio.aws.wafregional.model.DeleteRegexMatchSetResponse.ReadOnly
      ]
  object ListIPSets
      extends Effect[
        ListIpSetsRequest,
        AwsError,
        zio.aws.wafregional.model.ListIpSetsResponse.ReadOnly
      ]
  object DeleteSizeConstraintSet
      extends Effect[
        DeleteSizeConstraintSetRequest,
        AwsError,
        zio.aws.wafregional.model.DeleteSizeConstraintSetResponse.ReadOnly
      ]
  object GetSampledRequests
      extends Effect[
        GetSampledRequestsRequest,
        AwsError,
        zio.aws.wafregional.model.GetSampledRequestsResponse.ReadOnly
      ]
  object ListActivatedRulesInRuleGroup
      extends Effect[
        ListActivatedRulesInRuleGroupRequest,
        AwsError,
        zio.aws.wafregional.model.ListActivatedRulesInRuleGroupResponse.ReadOnly
      ]
  object DeleteIPSet
      extends Effect[
        DeleteIpSetRequest,
        AwsError,
        zio.aws.wafregional.model.DeleteIpSetResponse.ReadOnly
      ]
  object DeletePermissionPolicy
      extends Effect[
        DeletePermissionPolicyRequest,
        AwsError,
        zio.aws.wafregional.model.DeletePermissionPolicyResponse.ReadOnly
      ]
  object DeleteSqlInjectionMatchSet
      extends Effect[
        DeleteSqlInjectionMatchSetRequest,
        AwsError,
        zio.aws.wafregional.model.DeleteSqlInjectionMatchSetResponse.ReadOnly
      ]
  object ListSqlInjectionMatchSets
      extends Effect[
        ListSqlInjectionMatchSetsRequest,
        AwsError,
        zio.aws.wafregional.model.ListSqlInjectionMatchSetsResponse.ReadOnly
      ]
  object GetRule
      extends Effect[
        GetRuleRequest,
        AwsError,
        zio.aws.wafregional.model.GetRuleResponse.ReadOnly
      ]
  object CreateWebACLMigrationStack
      extends Effect[
        CreateWebAclMigrationStackRequest,
        AwsError,
        zio.aws.wafregional.model.CreateWebAclMigrationStackResponse.ReadOnly
      ]
  object CreateSqlInjectionMatchSet
      extends Effect[
        CreateSqlInjectionMatchSetRequest,
        AwsError,
        zio.aws.wafregional.model.CreateSqlInjectionMatchSetResponse.ReadOnly
      ]
  object CreateRule
      extends Effect[
        CreateRuleRequest,
        AwsError,
        zio.aws.wafregional.model.CreateRuleResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, WafRegional] = zio.ZIO
    .service[Proxy]
    .flatMap { proxy =>
      withRuntime[Proxy].map { rts =>
        new WafRegional {
          val api: WafRegionalAsyncClient = null
          def withAspect[R1](newAspect: AwsCallAspect[R1], r: ZEnvironment[R1])
              : WafRegional = this
          def listXssMatchSets(request: ListXssMatchSetsRequest): IO[
            AwsError,
            zio.aws.wafregional.model.ListXssMatchSetsResponse.ReadOnly
          ] = proxy(ListXssMatchSets, request)
          def getRuleGroup(request: GetRuleGroupRequest): IO[
            AwsError,
            zio.aws.wafregional.model.GetRuleGroupResponse.ReadOnly
          ] = proxy(GetRuleGroup, request)
          def listGeoMatchSets(request: ListGeoMatchSetsRequest): IO[
            AwsError,
            zio.aws.wafregional.model.ListGeoMatchSetsResponse.ReadOnly
          ] = proxy(ListGeoMatchSets, request)
          def updateByteMatchSet(request: UpdateByteMatchSetRequest): IO[
            AwsError,
            zio.aws.wafregional.model.UpdateByteMatchSetResponse.ReadOnly
          ] = proxy(UpdateByteMatchSet, request)
          def updateRegexMatchSet(request: UpdateRegexMatchSetRequest): IO[
            AwsError,
            zio.aws.wafregional.model.UpdateRegexMatchSetResponse.ReadOnly
          ] = proxy(UpdateRegexMatchSet, request)
          def createRegexMatchSet(request: CreateRegexMatchSetRequest): IO[
            AwsError,
            zio.aws.wafregional.model.CreateRegexMatchSetResponse.ReadOnly
          ] = proxy(CreateRegexMatchSet, request)
          def getWebACL(request: GetWebAclRequest): IO[
            AwsError,
            zio.aws.wafregional.model.GetWebAclResponse.ReadOnly
          ] = proxy(GetWebACL, request)
          def getRateBasedRule(request: GetRateBasedRuleRequest): IO[
            AwsError,
            zio.aws.wafregional.model.GetRateBasedRuleResponse.ReadOnly
          ] = proxy(GetRateBasedRule, request)
          def listSizeConstraintSets(
              request: ListSizeConstraintSetsRequest
          ): IO[
            AwsError,
            zio.aws.wafregional.model.ListSizeConstraintSetsResponse.ReadOnly
          ] = proxy(ListSizeConstraintSets, request)
          def listRegexMatchSets(request: ListRegexMatchSetsRequest): IO[
            AwsError,
            zio.aws.wafregional.model.ListRegexMatchSetsResponse.ReadOnly
          ] = proxy(ListRegexMatchSets, request)
          def getRegexMatchSet(request: GetRegexMatchSetRequest): IO[
            AwsError,
            zio.aws.wafregional.model.GetRegexMatchSetResponse.ReadOnly
          ] = proxy(GetRegexMatchSet, request)
          def listSubscribedRuleGroups(
              request: ListSubscribedRuleGroupsRequest
          ): IO[
            AwsError,
            zio.aws.wafregional.model.ListSubscribedRuleGroupsResponse.ReadOnly
          ] = proxy(ListSubscribedRuleGroups, request)
          def getSqlInjectionMatchSet(
              request: GetSqlInjectionMatchSetRequest
          ): IO[
            AwsError,
            zio.aws.wafregional.model.GetSqlInjectionMatchSetResponse.ReadOnly
          ] = proxy(GetSqlInjectionMatchSet, request)
          def getIPSet(
              request: GetIpSetRequest
          ): IO[AwsError, zio.aws.wafregional.model.GetIpSetResponse.ReadOnly] =
            proxy(GetIPSet, request)
          def createRuleGroup(request: CreateRuleGroupRequest): IO[
            AwsError,
            zio.aws.wafregional.model.CreateRuleGroupResponse.ReadOnly
          ] = proxy(CreateRuleGroup, request)
          def listRuleGroups(request: ListRuleGroupsRequest): IO[
            AwsError,
            zio.aws.wafregional.model.ListRuleGroupsResponse.ReadOnly
          ] = proxy(ListRuleGroups, request)
          def deleteRegexPatternSet(request: DeleteRegexPatternSetRequest): IO[
            AwsError,
            zio.aws.wafregional.model.DeleteRegexPatternSetResponse.ReadOnly
          ] = proxy(DeleteRegexPatternSet, request)
          def updateRateBasedRule(request: UpdateRateBasedRuleRequest): IO[
            AwsError,
            zio.aws.wafregional.model.UpdateRateBasedRuleResponse.ReadOnly
          ] = proxy(UpdateRateBasedRule, request)
          def disassociateWebACL(request: DisassociateWebAclRequest): IO[
            AwsError,
            zio.aws.wafregional.model.DisassociateWebAclResponse.ReadOnly
          ] = proxy(DisassociateWebACL, request)
          def listResourcesForWebACL(
              request: ListResourcesForWebAclRequest
          ): IO[
            AwsError,
            zio.aws.wafregional.model.ListResourcesForWebAclResponse.ReadOnly
          ] = proxy(ListResourcesForWebACL, request)
          def updateSqlInjectionMatchSet(
              request: UpdateSqlInjectionMatchSetRequest
          ): IO[
            AwsError,
            zio.aws.wafregional.model.UpdateSqlInjectionMatchSetResponse.ReadOnly
          ] = proxy(UpdateSqlInjectionMatchSet, request)
          def deleteGeoMatchSet(request: DeleteGeoMatchSetRequest): IO[
            AwsError,
            zio.aws.wafregional.model.DeleteGeoMatchSetResponse.ReadOnly
          ] = proxy(DeleteGeoMatchSet, request)
          def createIPSet(request: CreateIpSetRequest): IO[
            AwsError,
            zio.aws.wafregional.model.CreateIpSetResponse.ReadOnly
          ] = proxy(CreateIPSet, request)
          def getWebACLForResource(request: GetWebAclForResourceRequest): IO[
            AwsError,
            zio.aws.wafregional.model.GetWebAclForResourceResponse.ReadOnly
          ] = proxy(GetWebACLForResource, request)
          def getRateBasedRuleManagedKeys(
              request: GetRateBasedRuleManagedKeysRequest
          ): IO[
            AwsError,
            zio.aws.wafregional.model.GetRateBasedRuleManagedKeysResponse.ReadOnly
          ] = proxy(GetRateBasedRuleManagedKeys, request)
          def updateGeoMatchSet(request: UpdateGeoMatchSetRequest): IO[
            AwsError,
            zio.aws.wafregional.model.UpdateGeoMatchSetResponse.ReadOnly
          ] = proxy(UpdateGeoMatchSet, request)
          def listRegexPatternSets(request: ListRegexPatternSetsRequest): IO[
            AwsError,
            zio.aws.wafregional.model.ListRegexPatternSetsResponse.ReadOnly
          ] = proxy(ListRegexPatternSets, request)
          def listByteMatchSets(request: ListByteMatchSetsRequest): IO[
            AwsError,
            zio.aws.wafregional.model.ListByteMatchSetsResponse.ReadOnly
          ] = proxy(ListByteMatchSets, request)
          def updateIPSet(request: UpdateIpSetRequest): IO[
            AwsError,
            zio.aws.wafregional.model.UpdateIpSetResponse.ReadOnly
          ] = proxy(UpdateIPSet, request)
          def createRateBasedRule(request: CreateRateBasedRuleRequest): IO[
            AwsError,
            zio.aws.wafregional.model.CreateRateBasedRuleResponse.ReadOnly
          ] = proxy(CreateRateBasedRule, request)
          def deleteXssMatchSet(request: DeleteXssMatchSetRequest): IO[
            AwsError,
            zio.aws.wafregional.model.DeleteXssMatchSetResponse.ReadOnly
          ] = proxy(DeleteXssMatchSet, request)
          def getByteMatchSet(request: GetByteMatchSetRequest): IO[
            AwsError,
            zio.aws.wafregional.model.GetByteMatchSetResponse.ReadOnly
          ] = proxy(GetByteMatchSet, request)
          def deleteRule(request: DeleteRuleRequest): IO[
            AwsError,
            zio.aws.wafregional.model.DeleteRuleResponse.ReadOnly
          ] = proxy(DeleteRule, request)
          def getSizeConstraintSet(request: GetSizeConstraintSetRequest): IO[
            AwsError,
            zio.aws.wafregional.model.GetSizeConstraintSetResponse.ReadOnly
          ] = proxy(GetSizeConstraintSet, request)
          def createByteMatchSet(request: CreateByteMatchSetRequest): IO[
            AwsError,
            zio.aws.wafregional.model.CreateByteMatchSetResponse.ReadOnly
          ] = proxy(CreateByteMatchSet, request)
          def updateRule(request: UpdateRuleRequest): IO[
            AwsError,
            zio.aws.wafregional.model.UpdateRuleResponse.ReadOnly
          ] = proxy(UpdateRule, request)
          def associateWebACL(request: AssociateWebAclRequest): IO[
            AwsError,
            zio.aws.wafregional.model.AssociateWebAclResponse.ReadOnly
          ] = proxy(AssociateWebACL, request)
          def getRegexPatternSet(request: GetRegexPatternSetRequest): IO[
            AwsError,
            zio.aws.wafregional.model.GetRegexPatternSetResponse.ReadOnly
          ] = proxy(GetRegexPatternSet, request)
          def untagResource(request: UntagResourceRequest): IO[
            AwsError,
            zio.aws.wafregional.model.UntagResourceResponse.ReadOnly
          ] = proxy(UntagResource, request)
          def deleteRateBasedRule(request: DeleteRateBasedRuleRequest): IO[
            AwsError,
            zio.aws.wafregional.model.DeleteRateBasedRuleResponse.ReadOnly
          ] = proxy(DeleteRateBasedRule, request)
          def putLoggingConfiguration(
              request: PutLoggingConfigurationRequest
          ): IO[
            AwsError,
            zio.aws.wafregional.model.PutLoggingConfigurationResponse.ReadOnly
          ] = proxy(PutLoggingConfiguration, request)
          def getXssMatchSet(request: GetXssMatchSetRequest): IO[
            AwsError,
            zio.aws.wafregional.model.GetXssMatchSetResponse.ReadOnly
          ] = proxy(GetXssMatchSet, request)
          def deleteWebACL(request: DeleteWebAclRequest): IO[
            AwsError,
            zio.aws.wafregional.model.DeleteWebAclResponse.ReadOnly
          ] = proxy(DeleteWebACL, request)
          def createRegexPatternSet(request: CreateRegexPatternSetRequest): IO[
            AwsError,
            zio.aws.wafregional.model.CreateRegexPatternSetResponse.ReadOnly
          ] = proxy(CreateRegexPatternSet, request)
          def listWebACLs(request: ListWebAcLsRequest): IO[
            AwsError,
            zio.aws.wafregional.model.ListWebAcLsResponse.ReadOnly
          ] = proxy(ListWebACLs, request)
          def putPermissionPolicy(request: PutPermissionPolicyRequest): IO[
            AwsError,
            zio.aws.wafregional.model.PutPermissionPolicyResponse.ReadOnly
          ] = proxy(PutPermissionPolicy, request)
          def createXssMatchSet(request: CreateXssMatchSetRequest): IO[
            AwsError,
            zio.aws.wafregional.model.CreateXssMatchSetResponse.ReadOnly
          ] = proxy(CreateXssMatchSet, request)
          def getChangeTokenStatus(request: GetChangeTokenStatusRequest): IO[
            AwsError,
            zio.aws.wafregional.model.GetChangeTokenStatusResponse.ReadOnly
          ] = proxy(GetChangeTokenStatus, request)
          def createSizeConstraintSet(
              request: CreateSizeConstraintSetRequest
          ): IO[AwsError, ReadOnly] = proxy(CreateSizeConstraintSet, request)
          def getLoggingConfiguration(
              request: GetLoggingConfigurationRequest
          ): IO[
            AwsError,
            zio.aws.wafregional.model.GetLoggingConfigurationResponse.ReadOnly
          ] = proxy(GetLoggingConfiguration, request)
          def listTagsForResource(request: ListTagsForResourceRequest): IO[
            AwsError,
            zio.aws.wafregional.model.ListTagsForResourceResponse.ReadOnly
          ] = proxy(ListTagsForResource, request)
          def tagResource(request: TagResourceRequest): IO[
            AwsError,
            zio.aws.wafregional.model.TagResourceResponse.ReadOnly
          ] = proxy(TagResource, request)
          def listRules(request: ListRulesRequest): IO[
            AwsError,
            zio.aws.wafregional.model.ListRulesResponse.ReadOnly
          ] = proxy(ListRules, request)
          def listLoggingConfigurations(
              request: ListLoggingConfigurationsRequest
          ): IO[
            AwsError,
            zio.aws.wafregional.model.ListLoggingConfigurationsResponse.ReadOnly
          ] = proxy(ListLoggingConfigurations, request)
          def updateXssMatchSet(request: UpdateXssMatchSetRequest): IO[
            AwsError,
            zio.aws.wafregional.model.UpdateXssMatchSetResponse.ReadOnly
          ] = proxy(UpdateXssMatchSet, request)
          def deleteLoggingConfiguration(
              request: DeleteLoggingConfigurationRequest
          ): IO[
            AwsError,
            zio.aws.wafregional.model.DeleteLoggingConfigurationResponse.ReadOnly
          ] = proxy(DeleteLoggingConfiguration, request)
          def getGeoMatchSet(request: GetGeoMatchSetRequest): IO[
            AwsError,
            zio.aws.wafregional.model.GetGeoMatchSetResponse.ReadOnly
          ] = proxy(GetGeoMatchSet, request)
          def updateSizeConstraintSet(
              request: UpdateSizeConstraintSetRequest
          ): IO[
            AwsError,
            zio.aws.wafregional.model.UpdateSizeConstraintSetResponse.ReadOnly
          ] = proxy(UpdateSizeConstraintSet, request)
          def listRateBasedRules(request: ListRateBasedRulesRequest): IO[
            AwsError,
            zio.aws.wafregional.model.ListRateBasedRulesResponse.ReadOnly
          ] = proxy(ListRateBasedRules, request)
          def updateRuleGroup(request: UpdateRuleGroupRequest): IO[
            AwsError,
            zio.aws.wafregional.model.UpdateRuleGroupResponse.ReadOnly
          ] = proxy(UpdateRuleGroup, request)
          def updateRegexPatternSet(request: UpdateRegexPatternSetRequest): IO[
            AwsError,
            zio.aws.wafregional.model.UpdateRegexPatternSetResponse.ReadOnly
          ] = proxy(UpdateRegexPatternSet, request)
          def createWebACL(request: CreateWebAclRequest): IO[
            AwsError,
            zio.aws.wafregional.model.CreateWebAclResponse.ReadOnly
          ] = proxy(CreateWebACL, request)
          def createGeoMatchSet(request: CreateGeoMatchSetRequest): IO[
            AwsError,
            zio.aws.wafregional.model.CreateGeoMatchSetResponse.ReadOnly
          ] = proxy(CreateGeoMatchSet, request)
          def getPermissionPolicy(request: GetPermissionPolicyRequest): IO[
            AwsError,
            zio.aws.wafregional.model.GetPermissionPolicyResponse.ReadOnly
          ] = proxy(GetPermissionPolicy, request)
          def updateWebACL(request: UpdateWebAclRequest): IO[
            AwsError,
            zio.aws.wafregional.model.UpdateWebAclResponse.ReadOnly
          ] = proxy(UpdateWebACL, request)
          def deleteRuleGroup(request: DeleteRuleGroupRequest): IO[
            AwsError,
            zio.aws.wafregional.model.DeleteRuleGroupResponse.ReadOnly
          ] = proxy(DeleteRuleGroup, request)
          def deleteByteMatchSet(request: DeleteByteMatchSetRequest): IO[
            AwsError,
            zio.aws.wafregional.model.DeleteByteMatchSetResponse.ReadOnly
          ] = proxy(DeleteByteMatchSet, request)
          def getChangeToken(request: GetChangeTokenRequest): IO[
            AwsError,
            zio.aws.wafregional.model.GetChangeTokenResponse.ReadOnly
          ] = proxy(GetChangeToken, request)
          def deleteRegexMatchSet(request: DeleteRegexMatchSetRequest): IO[
            AwsError,
            zio.aws.wafregional.model.DeleteRegexMatchSetResponse.ReadOnly
          ] = proxy(DeleteRegexMatchSet, request)
          def listIPSets(request: ListIpSetsRequest): IO[
            AwsError,
            zio.aws.wafregional.model.ListIpSetsResponse.ReadOnly
          ] = proxy(ListIPSets, request)
          def deleteSizeConstraintSet(
              request: DeleteSizeConstraintSetRequest
          ): IO[
            AwsError,
            zio.aws.wafregional.model.DeleteSizeConstraintSetResponse.ReadOnly
          ] = proxy(DeleteSizeConstraintSet, request)
          def getSampledRequests(request: GetSampledRequestsRequest): IO[
            AwsError,
            zio.aws.wafregional.model.GetSampledRequestsResponse.ReadOnly
          ] = proxy(GetSampledRequests, request)
          def listActivatedRulesInRuleGroup(
              request: ListActivatedRulesInRuleGroupRequest
          ): IO[
            AwsError,
            zio.aws.wafregional.model.ListActivatedRulesInRuleGroupResponse.ReadOnly
          ] = proxy(ListActivatedRulesInRuleGroup, request)
          def deleteIPSet(request: DeleteIpSetRequest): IO[
            AwsError,
            zio.aws.wafregional.model.DeleteIpSetResponse.ReadOnly
          ] = proxy(DeleteIPSet, request)
          def deletePermissionPolicy(
              request: DeletePermissionPolicyRequest
          ): IO[
            AwsError,
            zio.aws.wafregional.model.DeletePermissionPolicyResponse.ReadOnly
          ] = proxy(DeletePermissionPolicy, request)
          def deleteSqlInjectionMatchSet(
              request: DeleteSqlInjectionMatchSetRequest
          ): IO[
            AwsError,
            zio.aws.wafregional.model.DeleteSqlInjectionMatchSetResponse.ReadOnly
          ] = proxy(DeleteSqlInjectionMatchSet, request)
          def listSqlInjectionMatchSets(
              request: ListSqlInjectionMatchSetsRequest
          ): IO[
            AwsError,
            zio.aws.wafregional.model.ListSqlInjectionMatchSetsResponse.ReadOnly
          ] = proxy(ListSqlInjectionMatchSets, request)
          def getRule(
              request: GetRuleRequest
          ): IO[AwsError, zio.aws.wafregional.model.GetRuleResponse.ReadOnly] =
            proxy(GetRule, request)
          def createWebACLMigrationStack(
              request: CreateWebAclMigrationStackRequest
          ): IO[
            AwsError,
            zio.aws.wafregional.model.CreateWebAclMigrationStackResponse.ReadOnly
          ] = proxy(CreateWebACLMigrationStack, request)
          def createSqlInjectionMatchSet(
              request: CreateSqlInjectionMatchSetRequest
          ): IO[
            AwsError,
            zio.aws.wafregional.model.CreateSqlInjectionMatchSetResponse.ReadOnly
          ] = proxy(CreateSqlInjectionMatchSet, request)
          def createRule(request: CreateRuleRequest): IO[
            AwsError,
            zio.aws.wafregional.model.CreateRuleResponse.ReadOnly
          ] = proxy(CreateRule, request)
        }
      }
    }
    .toLayer
}
