package zio.aws.wafregional.model
import zio.aws.wafregional.model.primitives.{ResourceName, ResourceId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class XssMatchSet(
    xssMatchSetId: ResourceId,
    name: Option[ResourceName] = None,
    xssMatchTuples: Iterable[zio.aws.wafregional.model.XssMatchTuple]
) {
  def buildAwsValue(): software.amazon.awssdk.services.waf.model.XssMatchSet = {
    import XssMatchSet.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.XssMatchSet
      .builder()
      .xssMatchSetId(ResourceId.unwrap(xssMatchSetId): java.lang.String)
      .optionallyWith(
        name.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.name)
      .xssMatchTuples(xssMatchTuples.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.wafregional.model.XssMatchSet.ReadOnly =
    zio.aws.wafregional.model.XssMatchSet.wrap(buildAwsValue())
}
object XssMatchSet {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.waf.model.XssMatchSet] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafregional.model.XssMatchSet =
      zio.aws.wafregional.model.XssMatchSet(
        xssMatchSetId,
        name.map(value => value),
        xssMatchTuples.map { item =>
          item.asEditable
        }
      )
    def xssMatchSetId: ResourceId
    def name: Option[ResourceName]
    def xssMatchTuples: List[zio.aws.wafregional.model.XssMatchTuple.ReadOnly]
    def getXssMatchSetId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(xssMatchSetId)
    def getName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("name", name)
    def getXssMatchTuples: ZIO[Any, Nothing, List[
      zio.aws.wafregional.model.XssMatchTuple.ReadOnly
    ]] = ZIO.succeed(xssMatchTuples)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.XssMatchSet
  ) extends zio.aws.wafregional.model.XssMatchSet.ReadOnly {
    override val xssMatchSetId: ResourceId =
      zio.aws.wafregional.model.primitives.ResourceId(impl.xssMatchSetId())
    override val name: Option[ResourceName] = scala
      .Option(impl.name())
      .map(value => zio.aws.wafregional.model.primitives.ResourceName(value))
    override val xssMatchTuples
        : List[zio.aws.wafregional.model.XssMatchTuple.ReadOnly] = impl
      .xssMatchTuples()
      .asScala
      .map { item =>
        zio.aws.wafregional.model.XssMatchTuple.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.XssMatchSet
  ): zio.aws.wafregional.model.XssMatchSet.ReadOnly = new Wrapper(impl)
}
