package zio.aws.wafregional.model
import zio.aws.wafregional.model.primitives.ChangeToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateGeoMatchSetResponse(
    changeToken: Option[ChangeToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.UpdateGeoMatchSetResponse = {
    import UpdateGeoMatchSetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.UpdateGeoMatchSetResponse
      .builder()
      .optionallyWith(
        changeToken.map(value => ChangeToken.unwrap(value): java.lang.String)
      )(_.changeToken)
      .build()
  }
  def asReadOnly: zio.aws.wafregional.model.UpdateGeoMatchSetResponse.ReadOnly =
    zio.aws.wafregional.model.UpdateGeoMatchSetResponse.wrap(buildAwsValue())
}
object UpdateGeoMatchSetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.UpdateGeoMatchSetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafregional.model.UpdateGeoMatchSetResponse =
      zio.aws.wafregional.model
        .UpdateGeoMatchSetResponse(changeToken.map(value => value))
    def changeToken: Option[ChangeToken]
    def getChangeToken: ZIO[Any, AwsError, ChangeToken] =
      AwsError.unwrapOptionField("changeToken", changeToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.UpdateGeoMatchSetResponse
  ) extends zio.aws.wafregional.model.UpdateGeoMatchSetResponse.ReadOnly {
    override val changeToken: Option[ChangeToken] = scala
      .Option(impl.changeToken())
      .map(value => zio.aws.wafregional.model.primitives.ChangeToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.UpdateGeoMatchSetResponse
  ): zio.aws.wafregional.model.UpdateGeoMatchSetResponse.ReadOnly = new Wrapper(
    impl
  )
}
