package zio.aws.wafregional.model
import zio.aws.wafregional.model.primitives.ResourceArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class TagInfoForResource(
    resourceARN: Option[ResourceArn] = None,
    tagList: Option[Iterable[zio.aws.wafregional.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.TagInfoForResource = {
    import TagInfoForResource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.TagInfoForResource
      .builder()
      .optionallyWith(
        resourceARN.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.resourceARN)
      .optionallyWith(
        tagList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagList)
      .build()
  }
  def asReadOnly: zio.aws.wafregional.model.TagInfoForResource.ReadOnly =
    zio.aws.wafregional.model.TagInfoForResource.wrap(buildAwsValue())
}
object TagInfoForResource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.TagInfoForResource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafregional.model.TagInfoForResource =
      zio.aws.wafregional.model.TagInfoForResource(
        resourceARN.map(value => value),
        tagList.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def resourceARN: Option[ResourceArn]
    def tagList: Option[List[zio.aws.wafregional.model.Tag.ReadOnly]]
    def getResourceARN: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("resourceARN", resourceARN)
    def getTagList
        : ZIO[Any, AwsError, List[zio.aws.wafregional.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tagList", tagList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.TagInfoForResource
  ) extends zio.aws.wafregional.model.TagInfoForResource.ReadOnly {
    override val resourceARN: Option[ResourceArn] = scala
      .Option(impl.resourceARN())
      .map(value => zio.aws.wafregional.model.primitives.ResourceArn(value))
    override val tagList: Option[List[zio.aws.wafregional.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tagList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.wafregional.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.TagInfoForResource
  ): zio.aws.wafregional.model.TagInfoForResource.ReadOnly = new Wrapper(impl)
}
