package zio.aws.wafregional.model
import zio.aws.wafregional.model.primitives.{
  ResourceId,
  Action,
  Timestamp,
  SampleWeight
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class SampledHTTPRequest(
    request: zio.aws.wafregional.model.HTTPRequest,
    weight: SampleWeight,
    timestamp: Option[Timestamp] = None,
    action: Option[Action] = None,
    ruleWithinRuleGroup: Option[ResourceId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.SampledHTTPRequest = {
    import SampledHTTPRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.SampledHTTPRequest
      .builder()
      .request(request.buildAwsValue())
      .weight(SampleWeight.unwrap(weight): java.lang.Long)
      .optionallyWith(timestamp.map(value => Timestamp.unwrap(value): Instant))(
        _.timestamp
      )
      .optionallyWith(
        action.map(value => Action.unwrap(value): java.lang.String)
      )(_.action)
      .optionallyWith(
        ruleWithinRuleGroup.map(value =>
          ResourceId.unwrap(value): java.lang.String
        )
      )(_.ruleWithinRuleGroup)
      .build()
  }
  def asReadOnly: zio.aws.wafregional.model.SampledHTTPRequest.ReadOnly =
    zio.aws.wafregional.model.SampledHTTPRequest.wrap(buildAwsValue())
}
object SampledHTTPRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.SampledHTTPRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafregional.model.SampledHTTPRequest =
      zio.aws.wafregional.model.SampledHTTPRequest(
        request.asEditable,
        weight,
        timestamp.map(value => value),
        action.map(value => value),
        ruleWithinRuleGroup.map(value => value)
      )
    def request: zio.aws.wafregional.model.HTTPRequest.ReadOnly
    def weight: SampleWeight
    def timestamp: Option[Timestamp]
    def action: Option[Action]
    def ruleWithinRuleGroup: Option[ResourceId]
    def getRequest
        : ZIO[Any, Nothing, zio.aws.wafregional.model.HTTPRequest.ReadOnly] =
      ZIO.succeed(request)
    def getWeight: ZIO[Any, Nothing, SampleWeight] = ZIO.succeed(weight)
    def getTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("timestamp", timestamp)
    def getAction: ZIO[Any, AwsError, Action] =
      AwsError.unwrapOptionField("action", action)
    def getRuleWithinRuleGroup: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("ruleWithinRuleGroup", ruleWithinRuleGroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.SampledHTTPRequest
  ) extends zio.aws.wafregional.model.SampledHTTPRequest.ReadOnly {
    override val request: zio.aws.wafregional.model.HTTPRequest.ReadOnly =
      zio.aws.wafregional.model.HTTPRequest.wrap(impl.request())
    override val weight: SampleWeight =
      zio.aws.wafregional.model.primitives.SampleWeight(impl.weight())
    override val timestamp: Option[Timestamp] = scala
      .Option(impl.timestamp())
      .map(value => zio.aws.wafregional.model.primitives.Timestamp(value))
    override val action: Option[Action] = scala
      .Option(impl.action())
      .map(value => zio.aws.wafregional.model.primitives.Action(value))
    override val ruleWithinRuleGroup: Option[ResourceId] = scala
      .Option(impl.ruleWithinRuleGroup())
      .map(value => zio.aws.wafregional.model.primitives.ResourceId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.SampledHTTPRequest
  ): zio.aws.wafregional.model.SampledHTTPRequest.ReadOnly = new Wrapper(impl)
}
