package zio.aws.wafregional.model
import zio.aws.wafregional.model.primitives.{ResourceName, ResourceId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class RuleGroupSummary(ruleGroupId: ResourceId, name: ResourceName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.RuleGroupSummary = {
    import RuleGroupSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.RuleGroupSummary
      .builder()
      .ruleGroupId(ResourceId.unwrap(ruleGroupId): java.lang.String)
      .name(ResourceName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.wafregional.model.RuleGroupSummary.ReadOnly =
    zio.aws.wafregional.model.RuleGroupSummary.wrap(buildAwsValue())
}
object RuleGroupSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.RuleGroupSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafregional.model.RuleGroupSummary =
      zio.aws.wafregional.model.RuleGroupSummary(ruleGroupId, name)
    def ruleGroupId: ResourceId
    def name: ResourceName
    def getRuleGroupId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(ruleGroupId)
    def getName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.RuleGroupSummary
  ) extends zio.aws.wafregional.model.RuleGroupSummary.ReadOnly {
    override val ruleGroupId: ResourceId =
      zio.aws.wafregional.model.primitives.ResourceId(impl.ruleGroupId())
    override val name: ResourceName =
      zio.aws.wafregional.model.primitives.ResourceName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.RuleGroupSummary
  ): zio.aws.wafregional.model.RuleGroupSummary.ReadOnly = new Wrapper(impl)
}
