package zio.aws.wafregional.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class PutLoggingConfigurationResponse(
    loggingConfiguration: Option[
      zio.aws.wafregional.model.LoggingConfiguration
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.PutLoggingConfigurationResponse = {
    import PutLoggingConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.PutLoggingConfigurationResponse
      .builder()
      .optionallyWith(loggingConfiguration.map(value => value.buildAwsValue()))(
        _.loggingConfiguration
      )
      .build()
  }
  def asReadOnly
      : zio.aws.wafregional.model.PutLoggingConfigurationResponse.ReadOnly =
    zio.aws.wafregional.model.PutLoggingConfigurationResponse
      .wrap(buildAwsValue())
}
object PutLoggingConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.PutLoggingConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafregional.model.PutLoggingConfigurationResponse =
      zio.aws.wafregional.model.PutLoggingConfigurationResponse(
        loggingConfiguration.map(value => value.asEditable)
      )
    def loggingConfiguration
        : Option[zio.aws.wafregional.model.LoggingConfiguration.ReadOnly]
    def getLoggingConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.wafregional.model.LoggingConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("loggingConfiguration", loggingConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.PutLoggingConfigurationResponse
  ) extends zio.aws.wafregional.model.PutLoggingConfigurationResponse.ReadOnly {
    override val loggingConfiguration
        : Option[zio.aws.wafregional.model.LoggingConfiguration.ReadOnly] =
      scala
        .Option(impl.loggingConfiguration())
        .map(value =>
          zio.aws.wafregional.model.LoggingConfiguration.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.PutLoggingConfigurationResponse
  ): zio.aws.wafregional.model.PutLoggingConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
