package zio.aws.wafregional.model
import zio.aws.wafregional.model.primitives.ResourceArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class LoggingConfiguration(
    resourceArn: ResourceArn,
    logDestinationConfigs: Iterable[ResourceArn],
    redactedFields: Option[Iterable[zio.aws.wafregional.model.FieldToMatch]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.LoggingConfiguration = {
    import LoggingConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.LoggingConfiguration
      .builder()
      .resourceArn(ResourceArn.unwrap(resourceArn): java.lang.String)
      .logDestinationConfigs(logDestinationConfigs.map { item =>
        ResourceArn.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        redactedFields.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.redactedFields)
      .build()
  }
  def asReadOnly: zio.aws.wafregional.model.LoggingConfiguration.ReadOnly =
    zio.aws.wafregional.model.LoggingConfiguration.wrap(buildAwsValue())
}
object LoggingConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.LoggingConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafregional.model.LoggingConfiguration =
      zio.aws.wafregional.model.LoggingConfiguration(
        resourceArn,
        logDestinationConfigs,
        redactedFields.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def resourceArn: ResourceArn
    def logDestinationConfigs: List[ResourceArn]
    def redactedFields
        : Option[List[zio.aws.wafregional.model.FieldToMatch.ReadOnly]]
    def getResourceArn: ZIO[Any, Nothing, ResourceArn] =
      ZIO.succeed(resourceArn)
    def getLogDestinationConfigs: ZIO[Any, Nothing, List[ResourceArn]] =
      ZIO.succeed(logDestinationConfigs)
    def getRedactedFields: ZIO[Any, AwsError, List[
      zio.aws.wafregional.model.FieldToMatch.ReadOnly
    ]] = AwsError.unwrapOptionField("redactedFields", redactedFields)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.LoggingConfiguration
  ) extends zio.aws.wafregional.model.LoggingConfiguration.ReadOnly {
    override val resourceArn: ResourceArn =
      zio.aws.wafregional.model.primitives.ResourceArn(impl.resourceArn())
    override val logDestinationConfigs: List[ResourceArn] = impl
      .logDestinationConfigs()
      .asScala
      .map { item =>
        zio.aws.wafregional.model.primitives.ResourceArn(item)
      }
      .toList
    override val redactedFields
        : Option[List[zio.aws.wafregional.model.FieldToMatch.ReadOnly]] = scala
      .Option(impl.redactedFields())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.wafregional.model.FieldToMatch.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.LoggingConfiguration
  ): zio.aws.wafregional.model.LoggingConfiguration.ReadOnly = new Wrapper(impl)
}
