package zio.aws.wafregional.model
import java.lang.Integer
import zio.aws.wafregional.model.primitives.{
  ResourceArn,
  PaginationLimit,
  NextMarker
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListTagsForResourceRequest(
    nextMarker: Option[NextMarker] = None,
    limit: Option[PaginationLimit] = None,
    resourceARN: ResourceArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.ListTagsForResourceRequest = {
    import ListTagsForResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.ListTagsForResourceRequest
      .builder()
      .optionallyWith(
        nextMarker.map(value => NextMarker.unwrap(value): java.lang.String)
      )(_.nextMarker)
      .optionallyWith(
        limit.map(value => PaginationLimit.unwrap(value): Integer)
      )(_.limit)
      .resourceARN(ResourceArn.unwrap(resourceARN): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.wafregional.model.ListTagsForResourceRequest.ReadOnly =
    zio.aws.wafregional.model.ListTagsForResourceRequest.wrap(buildAwsValue())
}
object ListTagsForResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.ListTagsForResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafregional.model.ListTagsForResourceRequest =
      zio.aws.wafregional.model.ListTagsForResourceRequest(
        nextMarker.map(value => value),
        limit.map(value => value),
        resourceARN
      )
    def nextMarker: Option[NextMarker]
    def limit: Option[PaginationLimit]
    def resourceARN: ResourceArn
    def getNextMarker: ZIO[Any, AwsError, NextMarker] =
      AwsError.unwrapOptionField("nextMarker", nextMarker)
    def getLimit: ZIO[Any, AwsError, PaginationLimit] =
      AwsError.unwrapOptionField("limit", limit)
    def getResourceARN: ZIO[Any, Nothing, ResourceArn] =
      ZIO.succeed(resourceARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.ListTagsForResourceRequest
  ) extends zio.aws.wafregional.model.ListTagsForResourceRequest.ReadOnly {
    override val nextMarker: Option[NextMarker] = scala
      .Option(impl.nextMarker())
      .map(value => zio.aws.wafregional.model.primitives.NextMarker(value))
    override val limit: Option[PaginationLimit] = scala
      .Option(impl.limit())
      .map(value => zio.aws.wafregional.model.primitives.PaginationLimit(value))
    override val resourceARN: ResourceArn =
      zio.aws.wafregional.model.primitives.ResourceArn(impl.resourceARN())
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.ListTagsForResourceRequest
  ): zio.aws.wafregional.model.ListTagsForResourceRequest.ReadOnly =
    new Wrapper(impl)
}
