package zio.aws.wafregional.model
import zio.aws.wafregional.model.primitives.NextMarker
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListSubscribedRuleGroupsResponse(
    nextMarker: Option[NextMarker] = None,
    ruleGroups: Option[
      Iterable[zio.aws.wafregional.model.SubscribedRuleGroupSummary]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.ListSubscribedRuleGroupsResponse = {
    import ListSubscribedRuleGroupsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.ListSubscribedRuleGroupsResponse
      .builder()
      .optionallyWith(
        nextMarker.map(value => NextMarker.unwrap(value): java.lang.String)
      )(_.nextMarker)
      .optionallyWith(
        ruleGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ruleGroups)
      .build()
  }
  def asReadOnly
      : zio.aws.wafregional.model.ListSubscribedRuleGroupsResponse.ReadOnly =
    zio.aws.wafregional.model.ListSubscribedRuleGroupsResponse
      .wrap(buildAwsValue())
}
object ListSubscribedRuleGroupsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.ListSubscribedRuleGroupsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafregional.model.ListSubscribedRuleGroupsResponse =
      zio.aws.wafregional.model.ListSubscribedRuleGroupsResponse(
        nextMarker.map(value => value),
        ruleGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextMarker: Option[NextMarker]
    def ruleGroups: Option[
      List[zio.aws.wafregional.model.SubscribedRuleGroupSummary.ReadOnly]
    ]
    def getNextMarker: ZIO[Any, AwsError, NextMarker] =
      AwsError.unwrapOptionField("nextMarker", nextMarker)
    def getRuleGroups: ZIO[Any, AwsError, List[
      zio.aws.wafregional.model.SubscribedRuleGroupSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("ruleGroups", ruleGroups)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.ListSubscribedRuleGroupsResponse
  ) extends zio.aws.wafregional.model.ListSubscribedRuleGroupsResponse.ReadOnly {
    override val nextMarker: Option[NextMarker] = scala
      .Option(impl.nextMarker())
      .map(value => zio.aws.wafregional.model.primitives.NextMarker(value))
    override val ruleGroups: Option[
      List[zio.aws.wafregional.model.SubscribedRuleGroupSummary.ReadOnly]
    ] = scala
      .Option(impl.ruleGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.wafregional.model.SubscribedRuleGroupSummary.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.ListSubscribedRuleGroupsResponse
  ): zio.aws.wafregional.model.ListSubscribedRuleGroupsResponse.ReadOnly =
    new Wrapper(impl)
}
