package zio.aws.wafregional.model
import zio.aws.wafregional.model.primitives.NextMarker
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListSizeConstraintSetsResponse(
    nextMarker: Option[NextMarker] = None,
    sizeConstraintSets: Option[
      Iterable[zio.aws.wafregional.model.SizeConstraintSetSummary]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.ListSizeConstraintSetsResponse = {
    import ListSizeConstraintSetsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.ListSizeConstraintSetsResponse
      .builder()
      .optionallyWith(
        nextMarker.map(value => NextMarker.unwrap(value): java.lang.String)
      )(_.nextMarker)
      .optionallyWith(
        sizeConstraintSets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sizeConstraintSets)
      .build()
  }
  def asReadOnly
      : zio.aws.wafregional.model.ListSizeConstraintSetsResponse.ReadOnly =
    zio.aws.wafregional.model.ListSizeConstraintSetsResponse
      .wrap(buildAwsValue())
}
object ListSizeConstraintSetsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.ListSizeConstraintSetsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafregional.model.ListSizeConstraintSetsResponse =
      zio.aws.wafregional.model.ListSizeConstraintSetsResponse(
        nextMarker.map(value => value),
        sizeConstraintSets.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextMarker: Option[NextMarker]
    def sizeConstraintSets: Option[
      List[zio.aws.wafregional.model.SizeConstraintSetSummary.ReadOnly]
    ]
    def getNextMarker: ZIO[Any, AwsError, NextMarker] =
      AwsError.unwrapOptionField("nextMarker", nextMarker)
    def getSizeConstraintSets: ZIO[Any, AwsError, List[
      zio.aws.wafregional.model.SizeConstraintSetSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("sizeConstraintSets", sizeConstraintSets)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.ListSizeConstraintSetsResponse
  ) extends zio.aws.wafregional.model.ListSizeConstraintSetsResponse.ReadOnly {
    override val nextMarker: Option[NextMarker] = scala
      .Option(impl.nextMarker())
      .map(value => zio.aws.wafregional.model.primitives.NextMarker(value))
    override val sizeConstraintSets: Option[
      List[zio.aws.wafregional.model.SizeConstraintSetSummary.ReadOnly]
    ] = scala
      .Option(impl.sizeConstraintSets())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.wafregional.model.SizeConstraintSetSummary.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.ListSizeConstraintSetsResponse
  ): zio.aws.wafregional.model.ListSizeConstraintSetsResponse.ReadOnly =
    new Wrapper(impl)
}
