package zio.aws.wafregional.model
import zio.aws.wafregional.model.primitives.NextMarker
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListRuleGroupsResponse(
    nextMarker: Option[NextMarker] = None,
    ruleGroups: Option[Iterable[zio.aws.wafregional.model.RuleGroupSummary]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.ListRuleGroupsResponse = {
    import ListRuleGroupsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.ListRuleGroupsResponse
      .builder()
      .optionallyWith(
        nextMarker.map(value => NextMarker.unwrap(value): java.lang.String)
      )(_.nextMarker)
      .optionallyWith(
        ruleGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ruleGroups)
      .build()
  }
  def asReadOnly: zio.aws.wafregional.model.ListRuleGroupsResponse.ReadOnly =
    zio.aws.wafregional.model.ListRuleGroupsResponse.wrap(buildAwsValue())
}
object ListRuleGroupsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.ListRuleGroupsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafregional.model.ListRuleGroupsResponse =
      zio.aws.wafregional.model.ListRuleGroupsResponse(
        nextMarker.map(value => value),
        ruleGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextMarker: Option[NextMarker]
    def ruleGroups
        : Option[List[zio.aws.wafregional.model.RuleGroupSummary.ReadOnly]]
    def getNextMarker: ZIO[Any, AwsError, NextMarker] =
      AwsError.unwrapOptionField("nextMarker", nextMarker)
    def getRuleGroups: ZIO[Any, AwsError, List[
      zio.aws.wafregional.model.RuleGroupSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("ruleGroups", ruleGroups)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.ListRuleGroupsResponse
  ) extends zio.aws.wafregional.model.ListRuleGroupsResponse.ReadOnly {
    override val nextMarker: Option[NextMarker] = scala
      .Option(impl.nextMarker())
      .map(value => zio.aws.wafregional.model.primitives.NextMarker(value))
    override val ruleGroups
        : Option[List[zio.aws.wafregional.model.RuleGroupSummary.ReadOnly]] =
      scala
        .Option(impl.ruleGroups())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.wafregional.model.RuleGroupSummary.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.ListRuleGroupsResponse
  ): zio.aws.wafregional.model.ListRuleGroupsResponse.ReadOnly = new Wrapper(
    impl
  )
}
