package zio.aws.wafregional.model
import zio.aws.wafregional.model.primitives.NextMarker
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListRegexPatternSetsResponse(
    nextMarker: Option[NextMarker] = None,
    regexPatternSets: Option[
      Iterable[zio.aws.wafregional.model.RegexPatternSetSummary]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.ListRegexPatternSetsResponse = {
    import ListRegexPatternSetsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.ListRegexPatternSetsResponse
      .builder()
      .optionallyWith(
        nextMarker.map(value => NextMarker.unwrap(value): java.lang.String)
      )(_.nextMarker)
      .optionallyWith(
        regexPatternSets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.regexPatternSets)
      .build()
  }
  def asReadOnly
      : zio.aws.wafregional.model.ListRegexPatternSetsResponse.ReadOnly =
    zio.aws.wafregional.model.ListRegexPatternSetsResponse.wrap(buildAwsValue())
}
object ListRegexPatternSetsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.ListRegexPatternSetsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafregional.model.ListRegexPatternSetsResponse =
      zio.aws.wafregional.model.ListRegexPatternSetsResponse(
        nextMarker.map(value => value),
        regexPatternSets.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextMarker: Option[NextMarker]
    def regexPatternSets: Option[
      List[zio.aws.wafregional.model.RegexPatternSetSummary.ReadOnly]
    ]
    def getNextMarker: ZIO[Any, AwsError, NextMarker] =
      AwsError.unwrapOptionField("nextMarker", nextMarker)
    def getRegexPatternSets: ZIO[Any, AwsError, List[
      zio.aws.wafregional.model.RegexPatternSetSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("regexPatternSets", regexPatternSets)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.ListRegexPatternSetsResponse
  ) extends zio.aws.wafregional.model.ListRegexPatternSetsResponse.ReadOnly {
    override val nextMarker: Option[NextMarker] = scala
      .Option(impl.nextMarker())
      .map(value => zio.aws.wafregional.model.primitives.NextMarker(value))
    override val regexPatternSets: Option[
      List[zio.aws.wafregional.model.RegexPatternSetSummary.ReadOnly]
    ] = scala
      .Option(impl.regexPatternSets())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.wafregional.model.RegexPatternSetSummary.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.ListRegexPatternSetsResponse
  ): zio.aws.wafregional.model.ListRegexPatternSetsResponse.ReadOnly =
    new Wrapper(impl)
}
