package zio.aws.wafregional.model
import zio.aws.wafregional.model.primitives.NextMarker
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListGeoMatchSetsResponse(
    nextMarker: Option[NextMarker] = None,
    geoMatchSets: Option[
      Iterable[zio.aws.wafregional.model.GeoMatchSetSummary]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.ListGeoMatchSetsResponse = {
    import ListGeoMatchSetsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.ListGeoMatchSetsResponse
      .builder()
      .optionallyWith(
        nextMarker.map(value => NextMarker.unwrap(value): java.lang.String)
      )(_.nextMarker)
      .optionallyWith(
        geoMatchSets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.geoMatchSets)
      .build()
  }
  def asReadOnly: zio.aws.wafregional.model.ListGeoMatchSetsResponse.ReadOnly =
    zio.aws.wafregional.model.ListGeoMatchSetsResponse.wrap(buildAwsValue())
}
object ListGeoMatchSetsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.ListGeoMatchSetsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafregional.model.ListGeoMatchSetsResponse =
      zio.aws.wafregional.model.ListGeoMatchSetsResponse(
        nextMarker.map(value => value),
        geoMatchSets.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextMarker: Option[NextMarker]
    def geoMatchSets
        : Option[List[zio.aws.wafregional.model.GeoMatchSetSummary.ReadOnly]]
    def getNextMarker: ZIO[Any, AwsError, NextMarker] =
      AwsError.unwrapOptionField("nextMarker", nextMarker)
    def getGeoMatchSets: ZIO[Any, AwsError, List[
      zio.aws.wafregional.model.GeoMatchSetSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("geoMatchSets", geoMatchSets)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.ListGeoMatchSetsResponse
  ) extends zio.aws.wafregional.model.ListGeoMatchSetsResponse.ReadOnly {
    override val nextMarker: Option[NextMarker] = scala
      .Option(impl.nextMarker())
      .map(value => zio.aws.wafregional.model.primitives.NextMarker(value))
    override val geoMatchSets
        : Option[List[zio.aws.wafregional.model.GeoMatchSetSummary.ReadOnly]] =
      scala
        .Option(impl.geoMatchSets())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.wafregional.model.GeoMatchSetSummary.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.ListGeoMatchSetsResponse
  ): zio.aws.wafregional.model.ListGeoMatchSetsResponse.ReadOnly = new Wrapper(
    impl
  )
}
