package zio.aws.wafregional.model
import java.lang.Integer
import zio.aws.wafregional.model.primitives.{PaginationLimit, NextMarker}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListByteMatchSetsRequest(
    nextMarker: Option[NextMarker] = None,
    limit: Option[PaginationLimit] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.ListByteMatchSetsRequest = {
    import ListByteMatchSetsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.ListByteMatchSetsRequest
      .builder()
      .optionallyWith(
        nextMarker.map(value => NextMarker.unwrap(value): java.lang.String)
      )(_.nextMarker)
      .optionallyWith(
        limit.map(value => PaginationLimit.unwrap(value): Integer)
      )(_.limit)
      .build()
  }
  def asReadOnly: zio.aws.wafregional.model.ListByteMatchSetsRequest.ReadOnly =
    zio.aws.wafregional.model.ListByteMatchSetsRequest.wrap(buildAwsValue())
}
object ListByteMatchSetsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.ListByteMatchSetsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafregional.model.ListByteMatchSetsRequest =
      zio.aws.wafregional.model.ListByteMatchSetsRequest(
        nextMarker.map(value => value),
        limit.map(value => value)
      )
    def nextMarker: Option[NextMarker]
    def limit: Option[PaginationLimit]
    def getNextMarker: ZIO[Any, AwsError, NextMarker] =
      AwsError.unwrapOptionField("nextMarker", nextMarker)
    def getLimit: ZIO[Any, AwsError, PaginationLimit] =
      AwsError.unwrapOptionField("limit", limit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.ListByteMatchSetsRequest
  ) extends zio.aws.wafregional.model.ListByteMatchSetsRequest.ReadOnly {
    override val nextMarker: Option[NextMarker] = scala
      .Option(impl.nextMarker())
      .map(value => zio.aws.wafregional.model.primitives.NextMarker(value))
    override val limit: Option[PaginationLimit] = scala
      .Option(impl.limit())
      .map(value => zio.aws.wafregional.model.primitives.PaginationLimit(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.ListByteMatchSetsRequest
  ): zio.aws.wafregional.model.ListByteMatchSetsRequest.ReadOnly = new Wrapper(
    impl
  )
}
