package zio.aws.wafregional.model
import zio.aws.wafregional.model.primitives.{ResourceName, ResourceId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class IPSet(
    ipSetId: ResourceId,
    name: Option[ResourceName] = None,
    ipSetDescriptors: Iterable[zio.aws.wafregional.model.IPSetDescriptor]
) {
  def buildAwsValue(): software.amazon.awssdk.services.waf.model.IPSet = {
    import IPSet.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.IPSet
      .builder()
      .ipSetId(ResourceId.unwrap(ipSetId): java.lang.String)
      .optionallyWith(
        name.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.name)
      .ipSetDescriptors(ipSetDescriptors.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.wafregional.model.IPSet.ReadOnly =
    zio.aws.wafregional.model.IPSet.wrap(buildAwsValue())
}
object IPSet {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.waf.model.IPSet] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafregional.model.IPSet =
      zio.aws.wafregional.model.IPSet(
        ipSetId,
        name.map(value => value),
        ipSetDescriptors.map { item =>
          item.asEditable
        }
      )
    def ipSetId: ResourceId
    def name: Option[ResourceName]
    def ipSetDescriptors
        : List[zio.aws.wafregional.model.IPSetDescriptor.ReadOnly]
    def getIpSetId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(ipSetId)
    def getName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("name", name)
    def getIpSetDescriptors: ZIO[Any, Nothing, List[
      zio.aws.wafregional.model.IPSetDescriptor.ReadOnly
    ]] = ZIO.succeed(ipSetDescriptors)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.IPSet
  ) extends zio.aws.wafregional.model.IPSet.ReadOnly {
    override val ipSetId: ResourceId =
      zio.aws.wafregional.model.primitives.ResourceId(impl.ipSetId())
    override val name: Option[ResourceName] = scala
      .Option(impl.name())
      .map(value => zio.aws.wafregional.model.primitives.ResourceName(value))
    override val ipSetDescriptors
        : List[zio.aws.wafregional.model.IPSetDescriptor.ReadOnly] = impl
      .ipSetDescriptors()
      .asScala
      .map { item =>
        zio.aws.wafregional.model.IPSetDescriptor.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.IPSet
  ): zio.aws.wafregional.model.IPSet.ReadOnly = new Wrapper(impl)
}
