package zio.aws.wafregional.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetXssMatchSetResponse(
    xssMatchSet: Option[zio.aws.wafregional.model.XssMatchSet] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.GetXssMatchSetResponse = {
    import GetXssMatchSetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.GetXssMatchSetResponse
      .builder()
      .optionallyWith(xssMatchSet.map(value => value.buildAwsValue()))(
        _.xssMatchSet
      )
      .build()
  }
  def asReadOnly: zio.aws.wafregional.model.GetXssMatchSetResponse.ReadOnly =
    zio.aws.wafregional.model.GetXssMatchSetResponse.wrap(buildAwsValue())
}
object GetXssMatchSetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.GetXssMatchSetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafregional.model.GetXssMatchSetResponse =
      zio.aws.wafregional.model
        .GetXssMatchSetResponse(xssMatchSet.map(value => value.asEditable))
    def xssMatchSet: Option[zio.aws.wafregional.model.XssMatchSet.ReadOnly]
    def getXssMatchSet
        : ZIO[Any, AwsError, zio.aws.wafregional.model.XssMatchSet.ReadOnly] =
      AwsError.unwrapOptionField("xssMatchSet", xssMatchSet)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.GetXssMatchSetResponse
  ) extends zio.aws.wafregional.model.GetXssMatchSetResponse.ReadOnly {
    override val xssMatchSet
        : Option[zio.aws.wafregional.model.XssMatchSet.ReadOnly] = scala
      .Option(impl.xssMatchSet())
      .map(value => zio.aws.wafregional.model.XssMatchSet.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.GetXssMatchSetResponse
  ): zio.aws.wafregional.model.GetXssMatchSetResponse.ReadOnly = new Wrapper(
    impl
  )
}
