package zio.aws.wafregional.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetWebAclForResourceResponse(
    webACLSummary: Option[zio.aws.wafregional.model.WebACLSummary] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.GetWebAclForResourceResponse = {
    import GetWebAclForResourceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.GetWebAclForResourceResponse
      .builder()
      .optionallyWith(webACLSummary.map(value => value.buildAwsValue()))(
        _.webACLSummary
      )
      .build()
  }
  def asReadOnly
      : zio.aws.wafregional.model.GetWebAclForResourceResponse.ReadOnly =
    zio.aws.wafregional.model.GetWebAclForResourceResponse.wrap(buildAwsValue())
}
object GetWebAclForResourceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.GetWebAclForResourceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafregional.model.GetWebAclForResourceResponse =
      zio.aws.wafregional.model.GetWebAclForResourceResponse(
        webACLSummary.map(value => value.asEditable)
      )
    def webACLSummary: Option[zio.aws.wafregional.model.WebACLSummary.ReadOnly]
    def getWebACLSummary
        : ZIO[Any, AwsError, zio.aws.wafregional.model.WebACLSummary.ReadOnly] =
      AwsError.unwrapOptionField("webACLSummary", webACLSummary)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.GetWebAclForResourceResponse
  ) extends zio.aws.wafregional.model.GetWebAclForResourceResponse.ReadOnly {
    override val webACLSummary
        : Option[zio.aws.wafregional.model.WebACLSummary.ReadOnly] = scala
      .Option(impl.webACLSummary())
      .map(value => zio.aws.wafregional.model.WebACLSummary.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.GetWebAclForResourceResponse
  ): zio.aws.wafregional.model.GetWebAclForResourceResponse.ReadOnly =
    new Wrapper(impl)
}
