package zio.aws.wafregional.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetSizeConstraintSetResponse(
    sizeConstraintSet: Option[zio.aws.wafregional.model.SizeConstraintSet] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.GetSizeConstraintSetResponse = {
    import GetSizeConstraintSetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.GetSizeConstraintSetResponse
      .builder()
      .optionallyWith(sizeConstraintSet.map(value => value.buildAwsValue()))(
        _.sizeConstraintSet
      )
      .build()
  }
  def asReadOnly
      : zio.aws.wafregional.model.GetSizeConstraintSetResponse.ReadOnly =
    zio.aws.wafregional.model.GetSizeConstraintSetResponse.wrap(buildAwsValue())
}
object GetSizeConstraintSetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.GetSizeConstraintSetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafregional.model.GetSizeConstraintSetResponse =
      zio.aws.wafregional.model.GetSizeConstraintSetResponse(
        sizeConstraintSet.map(value => value.asEditable)
      )
    def sizeConstraintSet
        : Option[zio.aws.wafregional.model.SizeConstraintSet.ReadOnly]
    def getSizeConstraintSet: ZIO[
      Any,
      AwsError,
      zio.aws.wafregional.model.SizeConstraintSet.ReadOnly
    ] = AwsError.unwrapOptionField("sizeConstraintSet", sizeConstraintSet)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.GetSizeConstraintSetResponse
  ) extends zio.aws.wafregional.model.GetSizeConstraintSetResponse.ReadOnly {
    override val sizeConstraintSet
        : Option[zio.aws.wafregional.model.SizeConstraintSet.ReadOnly] = scala
      .Option(impl.sizeConstraintSet())
      .map(value => zio.aws.wafregional.model.SizeConstraintSet.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.GetSizeConstraintSetResponse
  ): zio.aws.wafregional.model.GetSizeConstraintSetResponse.ReadOnly =
    new Wrapper(impl)
}
