package zio.aws.wafregional.model
import zio.aws.wafregional.model.primitives.PopulationSize
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetSampledRequestsResponse(
    sampledRequests: Option[
      Iterable[zio.aws.wafregional.model.SampledHTTPRequest]
    ] = None,
    populationSize: Option[PopulationSize] = None,
    timeWindow: Option[zio.aws.wafregional.model.TimeWindow] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.GetSampledRequestsResponse = {
    import GetSampledRequestsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.GetSampledRequestsResponse
      .builder()
      .optionallyWith(
        sampledRequests.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sampledRequests)
      .optionallyWith(
        populationSize.map(value =>
          PopulationSize.unwrap(value): java.lang.Long
        )
      )(_.populationSize)
      .optionallyWith(timeWindow.map(value => value.buildAwsValue()))(
        _.timeWindow
      )
      .build()
  }
  def asReadOnly
      : zio.aws.wafregional.model.GetSampledRequestsResponse.ReadOnly =
    zio.aws.wafregional.model.GetSampledRequestsResponse.wrap(buildAwsValue())
}
object GetSampledRequestsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.GetSampledRequestsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafregional.model.GetSampledRequestsResponse =
      zio.aws.wafregional.model.GetSampledRequestsResponse(
        sampledRequests.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        populationSize.map(value => value),
        timeWindow.map(value => value.asEditable)
      )
    def sampledRequests
        : Option[List[zio.aws.wafregional.model.SampledHTTPRequest.ReadOnly]]
    def populationSize: Option[PopulationSize]
    def timeWindow: Option[zio.aws.wafregional.model.TimeWindow.ReadOnly]
    def getSampledRequests: ZIO[Any, AwsError, List[
      zio.aws.wafregional.model.SampledHTTPRequest.ReadOnly
    ]] = AwsError.unwrapOptionField("sampledRequests", sampledRequests)
    def getPopulationSize: ZIO[Any, AwsError, PopulationSize] =
      AwsError.unwrapOptionField("populationSize", populationSize)
    def getTimeWindow
        : ZIO[Any, AwsError, zio.aws.wafregional.model.TimeWindow.ReadOnly] =
      AwsError.unwrapOptionField("timeWindow", timeWindow)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.GetSampledRequestsResponse
  ) extends zio.aws.wafregional.model.GetSampledRequestsResponse.ReadOnly {
    override val sampledRequests
        : Option[List[zio.aws.wafregional.model.SampledHTTPRequest.ReadOnly]] =
      scala
        .Option(impl.sampledRequests())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.wafregional.model.SampledHTTPRequest.wrap(item)
          }.toList
        )
    override val populationSize: Option[PopulationSize] = scala
      .Option(impl.populationSize())
      .map(value => zio.aws.wafregional.model.primitives.PopulationSize(value))
    override val timeWindow
        : Option[zio.aws.wafregional.model.TimeWindow.ReadOnly] = scala
      .Option(impl.timeWindow())
      .map(value => zio.aws.wafregional.model.TimeWindow.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.GetSampledRequestsResponse
  ): zio.aws.wafregional.model.GetSampledRequestsResponse.ReadOnly =
    new Wrapper(impl)
}
