package zio.aws.wafregional.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetRegexMatchSetResponse(
    regexMatchSet: Option[zio.aws.wafregional.model.RegexMatchSet] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.GetRegexMatchSetResponse = {
    import GetRegexMatchSetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.GetRegexMatchSetResponse
      .builder()
      .optionallyWith(regexMatchSet.map(value => value.buildAwsValue()))(
        _.regexMatchSet
      )
      .build()
  }
  def asReadOnly: zio.aws.wafregional.model.GetRegexMatchSetResponse.ReadOnly =
    zio.aws.wafregional.model.GetRegexMatchSetResponse.wrap(buildAwsValue())
}
object GetRegexMatchSetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.GetRegexMatchSetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafregional.model.GetRegexMatchSetResponse =
      zio.aws.wafregional.model
        .GetRegexMatchSetResponse(regexMatchSet.map(value => value.asEditable))
    def regexMatchSet: Option[zio.aws.wafregional.model.RegexMatchSet.ReadOnly]
    def getRegexMatchSet
        : ZIO[Any, AwsError, zio.aws.wafregional.model.RegexMatchSet.ReadOnly] =
      AwsError.unwrapOptionField("regexMatchSet", regexMatchSet)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.GetRegexMatchSetResponse
  ) extends zio.aws.wafregional.model.GetRegexMatchSetResponse.ReadOnly {
    override val regexMatchSet
        : Option[zio.aws.wafregional.model.RegexMatchSet.ReadOnly] = scala
      .Option(impl.regexMatchSet())
      .map(value => zio.aws.wafregional.model.RegexMatchSet.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.GetRegexMatchSetResponse
  ): zio.aws.wafregional.model.GetRegexMatchSetResponse.ReadOnly = new Wrapper(
    impl
  )
}
