package zio.aws.wafregional.model
import zio.aws.wafregional.model.primitives.ChangeToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DeleteWebAclResponse(changeToken: Option[ChangeToken] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.DeleteWebAclResponse = {
    import DeleteWebAclResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.DeleteWebAclResponse
      .builder()
      .optionallyWith(
        changeToken.map(value => ChangeToken.unwrap(value): java.lang.String)
      )(_.changeToken)
      .build()
  }
  def asReadOnly: zio.aws.wafregional.model.DeleteWebAclResponse.ReadOnly =
    zio.aws.wafregional.model.DeleteWebAclResponse.wrap(buildAwsValue())
}
object DeleteWebAclResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.DeleteWebAclResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafregional.model.DeleteWebAclResponse =
      zio.aws.wafregional.model
        .DeleteWebAclResponse(changeToken.map(value => value))
    def changeToken: Option[ChangeToken]
    def getChangeToken: ZIO[Any, AwsError, ChangeToken] =
      AwsError.unwrapOptionField("changeToken", changeToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.DeleteWebAclResponse
  ) extends zio.aws.wafregional.model.DeleteWebAclResponse.ReadOnly {
    override val changeToken: Option[ChangeToken] = scala
      .Option(impl.changeToken())
      .map(value => zio.aws.wafregional.model.primitives.ChangeToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.DeleteWebAclResponse
  ): zio.aws.wafregional.model.DeleteWebAclResponse.ReadOnly = new Wrapper(impl)
}
