package zio.aws.wafregional.model
import zio.aws.wafregional.model.primitives.ChangeToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DeleteSizeConstraintSetResponse(
    changeToken: Option[ChangeToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.DeleteSizeConstraintSetResponse = {
    import DeleteSizeConstraintSetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.DeleteSizeConstraintSetResponse
      .builder()
      .optionallyWith(
        changeToken.map(value => ChangeToken.unwrap(value): java.lang.String)
      )(_.changeToken)
      .build()
  }
  def asReadOnly
      : zio.aws.wafregional.model.DeleteSizeConstraintSetResponse.ReadOnly =
    zio.aws.wafregional.model.DeleteSizeConstraintSetResponse
      .wrap(buildAwsValue())
}
object DeleteSizeConstraintSetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.DeleteSizeConstraintSetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafregional.model.DeleteSizeConstraintSetResponse =
      zio.aws.wafregional.model
        .DeleteSizeConstraintSetResponse(changeToken.map(value => value))
    def changeToken: Option[ChangeToken]
    def getChangeToken: ZIO[Any, AwsError, ChangeToken] =
      AwsError.unwrapOptionField("changeToken", changeToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.DeleteSizeConstraintSetResponse
  ) extends zio.aws.wafregional.model.DeleteSizeConstraintSetResponse.ReadOnly {
    override val changeToken: Option[ChangeToken] = scala
      .Option(impl.changeToken())
      .map(value => zio.aws.wafregional.model.primitives.ChangeToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.DeleteSizeConstraintSetResponse
  ): zio.aws.wafregional.model.DeleteSizeConstraintSetResponse.ReadOnly =
    new Wrapper(impl)
}
