package zio.aws.wafregional.model
import zio.aws.wafregional.model.primitives.ChangeToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DeleteIpSetResponse(changeToken: Option[ChangeToken] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.DeleteIpSetResponse = {
    import DeleteIpSetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.DeleteIpSetResponse
      .builder()
      .optionallyWith(
        changeToken.map(value => ChangeToken.unwrap(value): java.lang.String)
      )(_.changeToken)
      .build()
  }
  def asReadOnly: zio.aws.wafregional.model.DeleteIpSetResponse.ReadOnly =
    zio.aws.wafregional.model.DeleteIpSetResponse.wrap(buildAwsValue())
}
object DeleteIpSetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.DeleteIpSetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafregional.model.DeleteIpSetResponse =
      zio.aws.wafregional.model
        .DeleteIpSetResponse(changeToken.map(value => value))
    def changeToken: Option[ChangeToken]
    def getChangeToken: ZIO[Any, AwsError, ChangeToken] =
      AwsError.unwrapOptionField("changeToken", changeToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.DeleteIpSetResponse
  ) extends zio.aws.wafregional.model.DeleteIpSetResponse.ReadOnly {
    override val changeToken: Option[ChangeToken] = scala
      .Option(impl.changeToken())
      .map(value => zio.aws.wafregional.model.primitives.ChangeToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.DeleteIpSetResponse
  ): zio.aws.wafregional.model.DeleteIpSetResponse.ReadOnly = new Wrapper(impl)
}
