package zio.aws.wafregional.model
import zio.aws.wafregional.model.primitives.ChangeToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateRuleGroupResponse(
    ruleGroup: Option[zio.aws.wafregional.model.RuleGroup] = None,
    changeToken: Option[ChangeToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.CreateRuleGroupResponse = {
    import CreateRuleGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.CreateRuleGroupResponse
      .builder()
      .optionallyWith(ruleGroup.map(value => value.buildAwsValue()))(
        _.ruleGroup
      )
      .optionallyWith(
        changeToken.map(value => ChangeToken.unwrap(value): java.lang.String)
      )(_.changeToken)
      .build()
  }
  def asReadOnly: zio.aws.wafregional.model.CreateRuleGroupResponse.ReadOnly =
    zio.aws.wafregional.model.CreateRuleGroupResponse.wrap(buildAwsValue())
}
object CreateRuleGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.CreateRuleGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafregional.model.CreateRuleGroupResponse =
      zio.aws.wafregional.model.CreateRuleGroupResponse(
        ruleGroup.map(value => value.asEditable),
        changeToken.map(value => value)
      )
    def ruleGroup: Option[zio.aws.wafregional.model.RuleGroup.ReadOnly]
    def changeToken: Option[ChangeToken]
    def getRuleGroup
        : ZIO[Any, AwsError, zio.aws.wafregional.model.RuleGroup.ReadOnly] =
      AwsError.unwrapOptionField("ruleGroup", ruleGroup)
    def getChangeToken: ZIO[Any, AwsError, ChangeToken] =
      AwsError.unwrapOptionField("changeToken", changeToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.CreateRuleGroupResponse
  ) extends zio.aws.wafregional.model.CreateRuleGroupResponse.ReadOnly {
    override val ruleGroup
        : Option[zio.aws.wafregional.model.RuleGroup.ReadOnly] = scala
      .Option(impl.ruleGroup())
      .map(value => zio.aws.wafregional.model.RuleGroup.wrap(value))
    override val changeToken: Option[ChangeToken] = scala
      .Option(impl.changeToken())
      .map(value => zio.aws.wafregional.model.primitives.ChangeToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.CreateRuleGroupResponse
  ): zio.aws.wafregional.model.CreateRuleGroupResponse.ReadOnly = new Wrapper(
    impl
  )
}
