package zio.aws.wafregional.model
import zio.aws.wafregional.model.primitives.ByteMatchTargetString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ByteMatchTuple(
    fieldToMatch: zio.aws.wafregional.model.FieldToMatch,
    targetString: ByteMatchTargetString,
    textTransformation: zio.aws.wafregional.model.TextTransformation,
    positionalConstraint: zio.aws.wafregional.model.PositionalConstraint
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.ByteMatchTuple = {
    import ByteMatchTuple.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.ByteMatchTuple
      .builder()
      .fieldToMatch(fieldToMatch.buildAwsValue())
      .targetString(
        software.amazon.awssdk.core.SdkBytes
          .fromByteArrayUnsafe(targetString.toArray[Byte])
      )
      .textTransformation(textTransformation.unwrap)
      .positionalConstraint(positionalConstraint.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.wafregional.model.ByteMatchTuple.ReadOnly =
    zio.aws.wafregional.model.ByteMatchTuple.wrap(buildAwsValue())
}
object ByteMatchTuple {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.ByteMatchTuple
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafregional.model.ByteMatchTuple =
      zio.aws.wafregional.model.ByteMatchTuple(
        fieldToMatch.asEditable,
        targetString,
        textTransformation,
        positionalConstraint
      )
    def fieldToMatch: zio.aws.wafregional.model.FieldToMatch.ReadOnly
    def targetString: ByteMatchTargetString
    def textTransformation: zio.aws.wafregional.model.TextTransformation
    def positionalConstraint: zio.aws.wafregional.model.PositionalConstraint
    def getFieldToMatch
        : ZIO[Any, Nothing, zio.aws.wafregional.model.FieldToMatch.ReadOnly] =
      ZIO.succeed(fieldToMatch)
    def getTargetString: ZIO[Any, Nothing, ByteMatchTargetString] =
      ZIO.succeed(targetString)
    def getTextTransformation
        : ZIO[Any, Nothing, zio.aws.wafregional.model.TextTransformation] =
      ZIO.succeed(textTransformation)
    def getPositionalConstraint
        : ZIO[Any, Nothing, zio.aws.wafregional.model.PositionalConstraint] =
      ZIO.succeed(positionalConstraint)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.ByteMatchTuple
  ) extends zio.aws.wafregional.model.ByteMatchTuple.ReadOnly {
    override val fieldToMatch: zio.aws.wafregional.model.FieldToMatch.ReadOnly =
      zio.aws.wafregional.model.FieldToMatch.wrap(impl.fieldToMatch())
    override val targetString: ByteMatchTargetString =
      zio.aws.wafregional.model.primitives.ByteMatchTargetString(
        zio.Chunk.fromArray(impl.targetString().asByteArrayUnsafe())
      )
    override val textTransformation
        : zio.aws.wafregional.model.TextTransformation =
      zio.aws.wafregional.model.TextTransformation
        .wrap(impl.textTransformation())
    override val positionalConstraint
        : zio.aws.wafregional.model.PositionalConstraint =
      zio.aws.wafregional.model.PositionalConstraint
        .wrap(impl.positionalConstraint())
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.ByteMatchTuple
  ): zio.aws.wafregional.model.ByteMatchTuple.ReadOnly = new Wrapper(impl)
}
