package zio.aws.wafregional.model
import zio.aws.wafregional.model.primitives.{ResourceName, ResourceId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ByteMatchSet(
    byteMatchSetId: ResourceId,
    name: Option[ResourceName] = None,
    byteMatchTuples: Iterable[zio.aws.wafregional.model.ByteMatchTuple]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.ByteMatchSet = {
    import ByteMatchSet.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.ByteMatchSet
      .builder()
      .byteMatchSetId(ResourceId.unwrap(byteMatchSetId): java.lang.String)
      .optionallyWith(
        name.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.name)
      .byteMatchTuples(byteMatchTuples.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.wafregional.model.ByteMatchSet.ReadOnly =
    zio.aws.wafregional.model.ByteMatchSet.wrap(buildAwsValue())
}
object ByteMatchSet {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.waf.model.ByteMatchSet] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafregional.model.ByteMatchSet =
      zio.aws.wafregional.model.ByteMatchSet(
        byteMatchSetId,
        name.map(value => value),
        byteMatchTuples.map { item =>
          item.asEditable
        }
      )
    def byteMatchSetId: ResourceId
    def name: Option[ResourceName]
    def byteMatchTuples: List[zio.aws.wafregional.model.ByteMatchTuple.ReadOnly]
    def getByteMatchSetId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(byteMatchSetId)
    def getName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("name", name)
    def getByteMatchTuples: ZIO[Any, Nothing, List[
      zio.aws.wafregional.model.ByteMatchTuple.ReadOnly
    ]] = ZIO.succeed(byteMatchTuples)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.ByteMatchSet
  ) extends zio.aws.wafregional.model.ByteMatchSet.ReadOnly {
    override val byteMatchSetId: ResourceId =
      zio.aws.wafregional.model.primitives.ResourceId(impl.byteMatchSetId())
    override val name: Option[ResourceName] = scala
      .Option(impl.name())
      .map(value => zio.aws.wafregional.model.primitives.ResourceName(value))
    override val byteMatchTuples
        : List[zio.aws.wafregional.model.ByteMatchTuple.ReadOnly] = impl
      .byteMatchTuples()
      .asScala
      .map { item =>
        zio.aws.wafregional.model.ByteMatchTuple.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.ByteMatchSet
  ): zio.aws.wafregional.model.ByteMatchSet.ReadOnly = new Wrapper(impl)
}
