package zio.aws.wafregional.model
import java.lang.Integer
import zio.aws.wafregional.model.primitives.{ResourceId, RulePriority}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ActivatedRule(
    priority: RulePriority,
    ruleId: ResourceId,
    action: Option[zio.aws.wafregional.model.WafAction] = None,
    overrideAction: Option[zio.aws.wafregional.model.WafOverrideAction] = None,
    `type`: Option[zio.aws.wafregional.model.WafRuleType] = None,
    excludedRules: Option[Iterable[zio.aws.wafregional.model.ExcludedRule]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.ActivatedRule = {
    import ActivatedRule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.ActivatedRule
      .builder()
      .priority(RulePriority.unwrap(priority): Integer)
      .ruleId(ResourceId.unwrap(ruleId): java.lang.String)
      .optionallyWith(action.map(value => value.buildAwsValue()))(_.action)
      .optionallyWith(overrideAction.map(value => value.buildAwsValue()))(
        _.overrideAction
      )
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        excludedRules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.excludedRules)
      .build()
  }
  def asReadOnly: zio.aws.wafregional.model.ActivatedRule.ReadOnly =
    zio.aws.wafregional.model.ActivatedRule.wrap(buildAwsValue())
}
object ActivatedRule {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.waf.model.ActivatedRule] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafregional.model.ActivatedRule =
      zio.aws.wafregional.model.ActivatedRule(
        priority,
        ruleId,
        action.map(value => value.asEditable),
        overrideAction.map(value => value.asEditable),
        `type`.map(value => value),
        excludedRules.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def priority: RulePriority
    def ruleId: ResourceId
    def action: Option[zio.aws.wafregional.model.WafAction.ReadOnly]
    def overrideAction
        : Option[zio.aws.wafregional.model.WafOverrideAction.ReadOnly]
    def `type`: Option[zio.aws.wafregional.model.WafRuleType]
    def excludedRules
        : Option[List[zio.aws.wafregional.model.ExcludedRule.ReadOnly]]
    def getPriority: ZIO[Any, Nothing, RulePriority] = ZIO.succeed(priority)
    def getRuleId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(ruleId)
    def getAction
        : ZIO[Any, AwsError, zio.aws.wafregional.model.WafAction.ReadOnly] =
      AwsError.unwrapOptionField("action", action)
    def getOverrideAction: ZIO[
      Any,
      AwsError,
      zio.aws.wafregional.model.WafOverrideAction.ReadOnly
    ] = AwsError.unwrapOptionField("overrideAction", overrideAction)
    def getType: ZIO[Any, AwsError, zio.aws.wafregional.model.WafRuleType] =
      AwsError.unwrapOptionField("type", `type`)
    def getExcludedRules: ZIO[Any, AwsError, List[
      zio.aws.wafregional.model.ExcludedRule.ReadOnly
    ]] = AwsError.unwrapOptionField("excludedRules", excludedRules)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.ActivatedRule
  ) extends zio.aws.wafregional.model.ActivatedRule.ReadOnly {
    override val priority: RulePriority =
      zio.aws.wafregional.model.primitives.RulePriority(impl.priority())
    override val ruleId: ResourceId =
      zio.aws.wafregional.model.primitives.ResourceId(impl.ruleId())
    override val action: Option[zio.aws.wafregional.model.WafAction.ReadOnly] =
      scala
        .Option(impl.action())
        .map(value => zio.aws.wafregional.model.WafAction.wrap(value))
    override val overrideAction
        : Option[zio.aws.wafregional.model.WafOverrideAction.ReadOnly] = scala
      .Option(impl.overrideAction())
      .map(value => zio.aws.wafregional.model.WafOverrideAction.wrap(value))
    override val `type`: Option[zio.aws.wafregional.model.WafRuleType] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.wafregional.model.WafRuleType.wrap(value))
    override val excludedRules
        : Option[List[zio.aws.wafregional.model.ExcludedRule.ReadOnly]] = scala
      .Option(impl.excludedRules())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.wafregional.model.ExcludedRule.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.ActivatedRule
  ): zio.aws.wafregional.model.ActivatedRule.ReadOnly = new Wrapper(impl)
}
