package zio.aws.wafregional.model
import zio.aws.wafregional.model.primitives.Timestamp
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class TimeWindow(startTime: Timestamp, endTime: Timestamp) {
  def buildAwsValue(): software.amazon.awssdk.services.waf.model.TimeWindow = {
    import TimeWindow.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.TimeWindow
      .builder()
      .startTime(Timestamp.unwrap(startTime): Instant)
      .endTime(Timestamp.unwrap(endTime): Instant)
      .build()
  }
  def asReadOnly: zio.aws.wafregional.model.TimeWindow.ReadOnly =
    zio.aws.wafregional.model.TimeWindow.wrap(buildAwsValue())
}
object TimeWindow {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.waf.model.TimeWindow] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafregional.model.TimeWindow =
      zio.aws.wafregional.model.TimeWindow(startTime, endTime)
    def startTime: Timestamp
    def endTime: Timestamp
    def getStartTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(startTime)
    def getEndTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(endTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.TimeWindow
  ) extends zio.aws.wafregional.model.TimeWindow.ReadOnly {
    override val startTime: Timestamp =
      zio.aws.wafregional.model.primitives.Timestamp(impl.startTime())
    override val endTime: Timestamp =
      zio.aws.wafregional.model.primitives.Timestamp(impl.endTime())
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.TimeWindow
  ): zio.aws.wafregional.model.TimeWindow.ReadOnly = new Wrapper(impl)
}
