package zio.aws.wafregional.model
import zio.aws.wafregional.model.primitives.ResourceId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListResourcesForWebAclRequest(
    webACLId: ResourceId,
    resourceType: Option[zio.aws.wafregional.model.ResourceType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.ListResourcesForWebAclRequest = {
    import ListResourcesForWebAclRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.ListResourcesForWebAclRequest
      .builder()
      .webACLId(ResourceId.unwrap(webACLId): java.lang.String)
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .build()
  }
  def asReadOnly
      : zio.aws.wafregional.model.ListResourcesForWebAclRequest.ReadOnly =
    zio.aws.wafregional.model.ListResourcesForWebAclRequest
      .wrap(buildAwsValue())
}
object ListResourcesForWebAclRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.ListResourcesForWebAclRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafregional.model.ListResourcesForWebAclRequest =
      zio.aws.wafregional.model.ListResourcesForWebAclRequest(
        webACLId,
        resourceType.map(value => value)
      )
    def webACLId: ResourceId
    def resourceType: Option[zio.aws.wafregional.model.ResourceType]
    def getWebACLId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(webACLId)
    def getResourceType
        : ZIO[Any, AwsError, zio.aws.wafregional.model.ResourceType] =
      AwsError.unwrapOptionField("resourceType", resourceType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.ListResourcesForWebAclRequest
  ) extends zio.aws.wafregional.model.ListResourcesForWebAclRequest.ReadOnly {
    override val webACLId: ResourceId =
      zio.aws.wafregional.model.primitives.ResourceId(impl.webACLId())
    override val resourceType: Option[zio.aws.wafregional.model.ResourceType] =
      scala
        .Option(impl.resourceType())
        .map(value => zio.aws.wafregional.model.ResourceType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.ListResourcesForWebAclRequest
  ): zio.aws.wafregional.model.ListResourcesForWebAclRequest.ReadOnly =
    new Wrapper(impl)
}
