package zio.aws.wafregional.model
import zio.aws.wafregional.model.primitives.ChangeToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateWebAclResponse(
    webACL: Option[zio.aws.wafregional.model.WebACL] = None,
    changeToken: Option[ChangeToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.CreateWebAclResponse = {
    import CreateWebAclResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.CreateWebAclResponse
      .builder()
      .optionallyWith(webACL.map(value => value.buildAwsValue()))(_.webACL)
      .optionallyWith(
        changeToken.map(value => ChangeToken.unwrap(value): java.lang.String)
      )(_.changeToken)
      .build()
  }
  def asReadOnly: zio.aws.wafregional.model.CreateWebAclResponse.ReadOnly =
    zio.aws.wafregional.model.CreateWebAclResponse.wrap(buildAwsValue())
}
object CreateWebAclResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.CreateWebAclResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafregional.model.CreateWebAclResponse =
      zio.aws.wafregional.model.CreateWebAclResponse(
        webACL.map(value => value.asEditable),
        changeToken.map(value => value)
      )
    def webACL: Option[zio.aws.wafregional.model.WebACL.ReadOnly]
    def changeToken: Option[ChangeToken]
    def getWebACL
        : ZIO[Any, AwsError, zio.aws.wafregional.model.WebACL.ReadOnly] =
      AwsError.unwrapOptionField("webACL", webACL)
    def getChangeToken: ZIO[Any, AwsError, ChangeToken] =
      AwsError.unwrapOptionField("changeToken", changeToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.CreateWebAclResponse
  ) extends zio.aws.wafregional.model.CreateWebAclResponse.ReadOnly {
    override val webACL: Option[zio.aws.wafregional.model.WebACL.ReadOnly] =
      scala
        .Option(impl.webACL())
        .map(value => zio.aws.wafregional.model.WebACL.wrap(value))
    override val changeToken: Option[ChangeToken] = scala
      .Option(impl.changeToken())
      .map(value => zio.aws.wafregional.model.primitives.ChangeToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.CreateWebAclResponse
  ): zio.aws.wafregional.model.CreateWebAclResponse.ReadOnly = new Wrapper(impl)
}
