package zio.aws.wafregional.model
import zio.aws.wafregional.model.primitives.ChangeToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateRegexMatchSetResponse(
    regexMatchSet: Option[zio.aws.wafregional.model.RegexMatchSet] = None,
    changeToken: Option[ChangeToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.CreateRegexMatchSetResponse = {
    import CreateRegexMatchSetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.CreateRegexMatchSetResponse
      .builder()
      .optionallyWith(regexMatchSet.map(value => value.buildAwsValue()))(
        _.regexMatchSet
      )
      .optionallyWith(
        changeToken.map(value => ChangeToken.unwrap(value): java.lang.String)
      )(_.changeToken)
      .build()
  }
  def asReadOnly
      : zio.aws.wafregional.model.CreateRegexMatchSetResponse.ReadOnly =
    zio.aws.wafregional.model.CreateRegexMatchSetResponse.wrap(buildAwsValue())
}
object CreateRegexMatchSetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.CreateRegexMatchSetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafregional.model.CreateRegexMatchSetResponse =
      zio.aws.wafregional.model.CreateRegexMatchSetResponse(
        regexMatchSet.map(value => value.asEditable),
        changeToken.map(value => value)
      )
    def regexMatchSet: Option[zio.aws.wafregional.model.RegexMatchSet.ReadOnly]
    def changeToken: Option[ChangeToken]
    def getRegexMatchSet
        : ZIO[Any, AwsError, zio.aws.wafregional.model.RegexMatchSet.ReadOnly] =
      AwsError.unwrapOptionField("regexMatchSet", regexMatchSet)
    def getChangeToken: ZIO[Any, AwsError, ChangeToken] =
      AwsError.unwrapOptionField("changeToken", changeToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.CreateRegexMatchSetResponse
  ) extends zio.aws.wafregional.model.CreateRegexMatchSetResponse.ReadOnly {
    override val regexMatchSet
        : Option[zio.aws.wafregional.model.RegexMatchSet.ReadOnly] = scala
      .Option(impl.regexMatchSet())
      .map(value => zio.aws.wafregional.model.RegexMatchSet.wrap(value))
    override val changeToken: Option[ChangeToken] = scala
      .Option(impl.changeToken())
      .map(value => zio.aws.wafregional.model.primitives.ChangeToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.CreateRegexMatchSetResponse
  ): zio.aws.wafregional.model.CreateRegexMatchSetResponse.ReadOnly =
    new Wrapper(impl)
}
