package zio.aws.wafregional.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class SizeConstraintSetUpdate(
    action: zio.aws.wafregional.model.ChangeAction,
    sizeConstraint: zio.aws.wafregional.model.SizeConstraint
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.SizeConstraintSetUpdate = {
    import SizeConstraintSetUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.SizeConstraintSetUpdate
      .builder()
      .action(action.unwrap)
      .sizeConstraint(sizeConstraint.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.wafregional.model.SizeConstraintSetUpdate.ReadOnly =
    zio.aws.wafregional.model.SizeConstraintSetUpdate.wrap(buildAwsValue())
}
object SizeConstraintSetUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.SizeConstraintSetUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafregional.model.SizeConstraintSetUpdate =
      zio.aws.wafregional.model
        .SizeConstraintSetUpdate(action, sizeConstraint.asEditable)
    def action: zio.aws.wafregional.model.ChangeAction
    def sizeConstraint: zio.aws.wafregional.model.SizeConstraint.ReadOnly
    def getAction: ZIO[Any, Nothing, zio.aws.wafregional.model.ChangeAction] =
      ZIO.succeed(action)
    def getSizeConstraint
        : ZIO[Any, Nothing, zio.aws.wafregional.model.SizeConstraint.ReadOnly] =
      ZIO.succeed(sizeConstraint)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.SizeConstraintSetUpdate
  ) extends zio.aws.wafregional.model.SizeConstraintSetUpdate.ReadOnly {
    override val action: zio.aws.wafregional.model.ChangeAction =
      zio.aws.wafregional.model.ChangeAction.wrap(impl.action())
    override val sizeConstraint
        : zio.aws.wafregional.model.SizeConstraint.ReadOnly =
      zio.aws.wafregional.model.SizeConstraint.wrap(impl.sizeConstraint())
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.SizeConstraintSetUpdate
  ): zio.aws.wafregional.model.SizeConstraintSetUpdate.ReadOnly = new Wrapper(
    impl
  )
}
