package zio.aws.wafregional.model
import zio.aws.wafregional.model.primitives.{ResourceId, Negated}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class Predicate(
    negated: Negated,
    `type`: zio.aws.wafregional.model.PredicateType,
    dataId: ResourceId
) {
  def buildAwsValue(): software.amazon.awssdk.services.waf.model.Predicate = {
    import Predicate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.Predicate
      .builder()
      .negated(Negated.unwrap(negated): java.lang.Boolean)
      .`type`(`type`.unwrap)
      .dataId(ResourceId.unwrap(dataId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.wafregional.model.Predicate.ReadOnly =
    zio.aws.wafregional.model.Predicate.wrap(buildAwsValue())
}
object Predicate {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.waf.model.Predicate] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafregional.model.Predicate =
      zio.aws.wafregional.model.Predicate(negated, `type`, dataId)
    def negated: Negated
    def `type`: zio.aws.wafregional.model.PredicateType
    def dataId: ResourceId
    def getNegated: ZIO[Any, Nothing, Negated] = ZIO.succeed(negated)
    def getType: ZIO[Any, Nothing, zio.aws.wafregional.model.PredicateType] =
      ZIO.succeed(`type`)
    def getDataId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(dataId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.Predicate
  ) extends zio.aws.wafregional.model.Predicate.ReadOnly {
    override val negated: Negated =
      zio.aws.wafregional.model.primitives.Negated(impl.negated())
    override val `type`: zio.aws.wafregional.model.PredicateType =
      zio.aws.wafregional.model.PredicateType.wrap(impl.`type`())
    override val dataId: ResourceId =
      zio.aws.wafregional.model.primitives.ResourceId(impl.dataId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.Predicate
  ): zio.aws.wafregional.model.Predicate.ReadOnly = new Wrapper(impl)
}
