package zio.aws.wafregional.model
import zio.aws.wafregional.model.primitives.NextMarker
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListWebAcLsResponse(
    nextMarker: Option[NextMarker] = None,
    webACLs: Option[Iterable[zio.aws.wafregional.model.WebACLSummary]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.ListWebAcLsResponse = {
    import ListWebAcLsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.ListWebAcLsResponse
      .builder()
      .optionallyWith(
        nextMarker.map(value => NextMarker.unwrap(value): java.lang.String)
      )(_.nextMarker)
      .optionallyWith(
        webACLs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.webACLs)
      .build()
  }
  def asReadOnly: zio.aws.wafregional.model.ListWebAcLsResponse.ReadOnly =
    zio.aws.wafregional.model.ListWebAcLsResponse.wrap(buildAwsValue())
}
object ListWebAcLsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.ListWebAcLsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafregional.model.ListWebAcLsResponse =
      zio.aws.wafregional.model.ListWebAcLsResponse(
        nextMarker.map(value => value),
        webACLs.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextMarker: Option[NextMarker]
    def webACLs: Option[List[zio.aws.wafregional.model.WebACLSummary.ReadOnly]]
    def getNextMarker: ZIO[Any, AwsError, NextMarker] =
      AwsError.unwrapOptionField("nextMarker", nextMarker)
    def getWebACLs: ZIO[Any, AwsError, List[
      zio.aws.wafregional.model.WebACLSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("webACLs", webACLs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.ListWebAcLsResponse
  ) extends zio.aws.wafregional.model.ListWebAcLsResponse.ReadOnly {
    override val nextMarker: Option[NextMarker] = scala
      .Option(impl.nextMarker())
      .map(value => zio.aws.wafregional.model.primitives.NextMarker(value))
    override val webACLs
        : Option[List[zio.aws.wafregional.model.WebACLSummary.ReadOnly]] = scala
      .Option(impl.webACLs())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.wafregional.model.WebACLSummary.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.ListWebAcLsResponse
  ): zio.aws.wafregional.model.ListWebAcLsResponse.ReadOnly = new Wrapper(impl)
}
